/*	$Id: probing_manager.h 2709 2005-10-30 09:25:51Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PROBING_MANAGER_H
#define PROBING_MANAGER_H

#include <vector>
#include <portablethreads/random.h>
#include <platypus/types/search_space.h>

namespace Platypus
{
	namespace ProbingPolicy
	{
		class PolicyBase;
	}

	class ProbingManager
	{
	public:
		typedef SearchSpace::iterator_type<toolbox::bin_tree_leafs_only_tag>::iterator search_space_iterator;
		typedef std::vector<search_space_iterator> Candidates;
		typedef Candidates::iterator iterator; 
		ProbingManager(unsigned initial, unsigned probes, unsigned bestn, bool enabled = false);
		SearchSpace::cursor select();
		bool restart();
		void markBacktrack();
		void markAnswerSet();
		bool exhausted() const;
		void setSearchSpace(SearchSpace& space);
		void setPolicy(ProbingPolicy::PolicyBase& policy);
	private:
		SearchSpace::cursor selectEnabled();
		SearchSpace::cursor selectDisabled();
		void updateCounters();
	private:
		Candidates candidates_;
		SearchSpace* space_;
		ProbingPolicy::PolicyBase* policy_;
		PortableThreads::PTRandom rng_;
		unsigned backtracksBeforeRestart_;
		unsigned backtrackCounter_;
		unsigned probes_;
		unsigned probeCounter_;
		unsigned bestN_;
		bool enabled_;		
	};
}

#endif
