/*	$Id: delegatable_choice_policy.cpp 1841 2005-05-23 17:50:55Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


#include <cassert>
#include <algorithm>
#include <functional>
#include <platypus/factories/registration.h>
#include <platypus/factories/probing_policy_factory.h>
#include <platypus/types/search_space.h>
#include <platypus/types/probing_policy.h>

using namespace std;

namespace Platypus
{
	template<>
	void factoryRegistration<ProbingPolicy::Null>()
	{
		ProbingPolicyFactory::instance().add("random", ProbingPolicy::Null::create, "Pick random part");
	}
	template<>
	void factoryRegistration<ProbingPolicy::Largest>()
	{
		ProbingPolicyFactory::instance().add("largest", ProbingPolicy::Largest::create, "Prefer big unexplored parts");
	}
	namespace ProbingPolicy
	{
		Null::iterator Null::choose(iterator begin, iterator end, size_t bestn)
		{
			return end;
		}
		PolicyBase* Null::create()
		{
			return new Null;
		}	
		void  Null::setup(SearchSpace& space)
		{}

		namespace 
		{
			// allow to compare the distance of two bin_tree iterators relative to the 
			// root of the binary tree
			typedef PolicyBase::iterator::value_type tree_iterator;
			class Distance : public binary_function<tree_iterator, tree_iterator, bool>
			{
			public:
				typedef PolicyBase::iterator::value_type tree_iterator;
				Distance(SearchSpace& space)
					:	root_(space.root())
				{}
				inline bool operator()(const tree_iterator& lhs, const tree_iterator& rhs) const
				{
					return distance(lhs) < distance(rhs);
				}
			private:
				unsigned distance(tree_iterator c) const
				{
					unsigned d = 0;
					while(c != root_)
					{
						++d;
						c.ascend();
					}
					return d;
				}
			private:
				const tree_iterator root_;
			};
		}
		Largest::iterator Largest::choose(iterator begin, iterator end, size_t bestn)
		{
			assert(space_);
			assert(bestn <= static_cast<size_t>(distance(begin, end)));
			const iterator n = begin + bestn;
			nth_element(begin, n, end, Distance(*space_));
			return n;
		}
		PolicyBase* Largest::create()
		{
			return new Largest;
		}
		void  Largest::setup(SearchSpace& space)
		{
			space_ = &space;
		}
	}
}
