/*	$Id: delegatable_choice_policy.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PROBING_POLICY_H
#define PROBING_POLICY_H

#include <platypus/types/probing_manager.h>

namespace Platypus
{
	class SearchSpace;
	namespace ProbingPolicy
	{
		class PolicyBase
		{
		public:
			typedef ProbingManager::iterator iterator;
			virtual ~PolicyBase()
			{}
			virtual void setup(SearchSpace& space) = 0;
			virtual iterator choose(iterator begin, iterator end, size_t bestn) = 0;			
		};

		const char* const NULL_KEY = "dont-care";
		const char* const NULL_DESCRIPTION = "don't care";
		class Null : public PolicyBase
		{
		public:
			typedef PolicyBase::iterator iterator;
			void setup(SearchSpace& space);
			iterator choose(iterator begin, iterator end, size_t bestn);
			static PolicyBase* create();
		};

		const char* const LARGEST_KEY = "largest-unexplored";
		const char* const LARGEST_DESCRIPTION = "Choose the largest part of the unexplored search space";
		class Largest : public PolicyBase
		{
		public:
			typedef PolicyBase::iterator iterator;
			void setup(SearchSpace& space);
			iterator choose(iterator begin, iterator end, size_t bestn);
			static PolicyBase* create();
		private:
			SearchSpace* space_;
		};
	}
};

#endif
