#include "config.h"
#include "lowercase.h"

#ifdef PT_HAVE_SUNOS

#include <sys/systeminfo.h>
#include <string>
#include <cassert>
#include "system.h"

using namespace std;
//long sysinfo(int command, char *buf, long count);

namespace
{
	string info(int cmd)
	{
		char buf[1024];
		memset(buf, 0, sizeof(buf));
		sysinfo(cmd, buf, sizeof(buf));
		return string(lowercase(buf));
	}

	string system()
	{
		return info(SI_SYSNAME);
	}

	string machine()
	{
		string arch(info(SI_MACHINE));
		arch += ' ';
		arch += info(SI_ARCHITECTURE);
		return arch;
	}

	string isalist()
	{
		return info(SI_ISALIST);
	}
}

void getSystemInformation(system_information_t& info)
{
	info.machine_ = machine();
	info.machine_details_ = isalist();
	info.os_ = system();
}

#endif // HAVE_SUNOS

