/*  Copyright (c) October 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <portablethreads/time.h>
#include <portablethreads/exception.h>
#include <cassert>

// PTime::stamp, sleep functions
#ifdef PT_WINDOWS
#	include <portablethreads/win32/time.cpp> 
#endif
#ifdef PT_UNIX
#	include <portablethreads/unix/time.cpp> 
#endif


namespace PortableThreads
{
	PTime::~PTime()
	{}
	PTime::PTime()
			:	start_(0)
			,	end_(0)
	{
		if(!frequency_)
			throw PTResourceError("[PTime] This platform does not support high performance clocks!");
	}

	PTime::time_type PTime::frequency()
	{
		return frequency_;
	}

	void PTime::start()
	{
		start_ = end_ = stamp();
	}
	void PTime::stop()
	{ 
		end_ = stamp();
	}

	PTime::time_type PTime::difference() const
	{
		return end_ - start_;
	}
	
}

