#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/config.h>

#define PT_ARCH_COMMON_INCLUDED

#include <portablethreads/arch/free-high-bits-muxer.h>


using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

#ifdef _MSC_VER
#	pragma warning(disable:4311) // pointer to int
#	pragma warning(disable:4312) // int to pointer
#endif


template<typename Muxer>
class FreeHighBitsMuxerTest : public CppUnit::TestFixture
{
public:
	typedef typename Muxer::int_t int_t;
	FreeHighBitsMuxerTest()
	{
		CPPUNIT_ASSERT(sizeof(int_t) >= 8);
	}

	void testCombination(int_t p, int_t count, int_t userbits, bool testcount)
	{
		int_t mux = Muxer::multiplex(p, count, userbits);
		CPPUNIT_ASSERT_EQUAL(p, Muxer::pointer(mux));
		CPPUNIT_ASSERT_EQUAL(userbits, Muxer::userbits(mux));
		if(testcount)
			CPPUNIT_ASSERT_EQUAL(count, Muxer::count(mux));
	}
	void testPointerIsZero()
	{
		int_t p = 0;
		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 43884, 0, true);
		testCombination(p, 43884, 1, true);
		testCombination(p, 43884, 2, true);
		testCombination(p, 43884, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
	}

	void testMuxerWithHighOnesPointerIsZero()
	{
		int_t p = 0;

		int_t highones = Muxer::freeBits();
		highones = (static_cast<int_t>(1) << highones) - 1;
		highones <<= Muxer::hardwarePointerBits();
		CPPUNIT_ASSERT_EQUAL(static_cast<int_t>(0), p & static_cast<int_t>(highones));

		p |= highones;
		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 43884, 0, true);
		testCombination(p, 43884, 1, true);
		testCombination(p, 43884, 2, true);
		testCombination(p, 43884, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
	}
	void testMuxerWithHighZerosPointer()
	{
		int_t p = static_cast<int_t>(1) << 30;
		p ^= static_cast<int_t>(23939) << 3;
		CPPUNIT_ASSERT(p < (static_cast<int_t>(1) << Muxer::hardwarePointerBits()));

		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 43884, 0, true);
		testCombination(p, 43884, 1, true);
		testCombination(p, 43884, 2, true);
		testCombination(p, 43884, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);

		
	}
	void testMuxerWithHighOnesPointer()
	{
		int_t p = static_cast<int_t>(1) << 30;
		p ^= static_cast<int_t>(23939) << 3;
		CPPUNIT_ASSERT(p < (static_cast<int_t>(1) << Muxer::hardwarePointerBits()));

		int_t highones = Muxer::freeBits();
		highones = (static_cast<int_t>(1) << highones) - 1;
		highones <<= Muxer::hardwarePointerBits();
		CPPUNIT_ASSERT_EQUAL(static_cast<int_t>(0), p & static_cast<int_t>(highones));

		p |= highones;

		CPPUNIT_ASSERT_EQUAL(highones, p & static_cast<int_t>(highones));

		testCombination(p, 0, 0, true);
		testCombination(p, 0, 1, true);
		testCombination(p, 0, 2, true);
		testCombination(p, 0, 3, true);
		testCombination(p, 43884, 0, true);
		testCombination(p, 43884, 1, true);
		testCombination(p, 43884, 2, true);
		testCombination(p, 43884, 3, true);
		
		int_t count = static_cast<int_t>(1) << Muxer::freeBits();
		testCombination(p, count, 0, false);
		testCombination(p, count, 1, false);
		testCombination(p, count, 2, false);
		testCombination(p, count, 3, false);
		
	}
	
	CPPUNIT_TEST_SUITE( FreeHighBitsMuxerTest );
		CPPUNIT_TEST( testPointerIsZero );
		CPPUNIT_TEST( testMuxerWithHighOnesPointerIsZero );
		CPPUNIT_TEST( testMuxerWithHighZerosPointer );
		CPPUNIT_TEST( testMuxerWithHighOnesPointer );
	CPPUNIT_TEST_SUITE_END();
};
typedef ::PortableThreads::LockFree::Private::FreeHighBitsMuxer< ::PortableThreads::int64, 64, 32, 2, 2> IA32LikeMuxer;
typedef ::PortableThreads::LockFree::Private::FreeHighBitsMuxer< ::PortableThreads::int64, 64, 48, 3, 2> AMD64LikeMuxer;
typedef ::PortableThreads::LockFree::Private::FreeHighBitsMuxer< ::PortableThreads::int64, 64, 44, 3, 2> UltraSparcLikeMuxer;

typedef FreeHighBitsMuxerTest< IA32LikeMuxer > IA32Test;
typedef FreeHighBitsMuxerTest< AMD64LikeMuxer > AMDTest;
typedef FreeHighBitsMuxerTest< UltraSparcLikeMuxer > SunTest;


CPPUNIT_TEST_SUITE_REGISTRATION( IA32Test );
CPPUNIT_TEST_SUITE_REGISTRATION( AMDTest );
CPPUNIT_TEST_SUITE_REGISTRATION( SunTest ); 




