#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/config.h>


using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

#ifdef _MSC_VER
#	pragma warning(disable:4311) // pointer to int
#	pragma warning(disable:4312) // int to pointer
#endif


class PlatformPointerCASTest : public CppUnit::TestFixture
{
public:
	typedef PortableThreads::LockFree::Private::PTPointerCAS PTPointerCAS;
	typedef PTPointerCAS::token_t token_t;
	void testPointerCAS()
	{
		PTPointerCAS x(0);
		void* p = 0;
		
		token_t t, nt;
		
		nt = t = x.get();
		nt.pointer(reinterpret_cast<PTPointerCAS::int_t>(p));
		x.cas(nt, t);
		CPPUNIT_ASSERT_EQUAL(p, reinterpret_cast<void*>(x.get().pointer()));

		p = reinterpret_cast<void*>(0xffff3430);
		nt = t = x.get();
		nt.pointer(reinterpret_cast<PTPointerCAS::int_t>(p));
		x.cas(nt, t);
		CPPUNIT_ASSERT_EQUAL(p, reinterpret_cast<void*>(x.get().pointer()));
	}
	CPPUNIT_TEST_SUITE( PlatformPointerCASTest );
		CPPUNIT_TEST( testPointerCAS );
	CPPUNIT_TEST_SUITE_END();
};

CPPUNIT_TEST_SUITE_REGISTRATION( PlatformPointerCASTest );




