#ifndef MPI_PLATYPUS_TYPES_H
#define MPI_PLATYPUS_TYPES_H

#include <vector>

namespace Platypus{

  //tags for mpi message types
  const unsigned ANSWER_MESSAGE_TAG = 1;
  const unsigned TERMINATE_TAG = 2;
  const unsigned TERMINATE_CONFIRMATION_TAG = 3;
  const unsigned DC_REQUEST_TAG = 4;
  const unsigned DC_TAG_FROM_SLAVE =5;
  const unsigned DC_TAG_FROM_CONTROLLER = 6;
  const unsigned DC_FROM_CONTROLLER_DENIED = 7;
  const unsigned DC_NEEDED_TAG = 8;
  //const unsigned STATS_TAG = 9;
  //const unsigned SHOULD_DELEGATE_TAG = 10;

  //indentifiers for the different mpi process types
  const unsigned MASTER = 0;

  //number of stats each process tracks
  const unsigned NUM_STATS = 8;

  //indexes into stats vector
  const unsigned EXPANDER_INITS = 0;
  const unsigned CONFLICTS = 1;
  const unsigned MODELS = 2;
  const unsigned BACKTRACKS = 3;
  const unsigned DELEGATIONS = 4;
  const unsigned MESSAGES_SENT = 5;
  const unsigned MESSAGES_RECEIVED = 6;
  const unsigned DROPPED_REQUESTS = 7;

  //possible work states as tracked by the master
  const unsigned INITIAL = 0;
  const unsigned FILED = 1;
  const unsigned DELEGATED = 2;
  
  //message buffer used for passing around PA's and DC's
  typedef std::vector<unsigned long> MessageBuffer;

}

#endif
