#include <nomore/nomore_program.h>
#include <nomore/nomore_system.h>
#include <platypus/factories/registration.h>
#include <platypus/factories/program_factory.h>

namespace Platypus { namespace Nomore {

Program::Program()
	: nomore_(0) {
}

Program::~Program() {
	if (expanders_.get() > 0) {
		// the first expander already killed this nomore instance.
		nomore_.release();
	}
}

void Program::setup(std::istream& is) {
	nomore_.reset( new NomoreSystem( is ) );
	nomore_->getAtoms(atoms_);	
}


std::string Program::idToName(AtomId id) const {
	return nomore_->getAtomName(id);
}

const Program::CollectionType& Program::atoms() const {
	return atoms_;
}

size_t Program::numberOfAtoms() const  {
	return atoms_.size();
}

size_t Program::numberOfRules() const {
	return nomore_->getNumberOfRules();
}

bool Program::hasDisplayName(AtomId id) const {
	return nomore_->getAtomName(id).empty() == false;
}

NomoreSystem* Program::createNomoreSystem() const {
	if (++expanders_ == 1) {
		return nomore_.get();
	}
	return nomore_->clone();
}

} } // end namespace Platypus::Nomore

namespace Platypus {

///////////////////////////////////////////////////////////////////////////////
// factory registration code
///////////////////////////////////////////////////////////////////////////////
static ProgramInterface* create() 
{
    return new Nomore::Program;
}

template<>
void factoryRegistration<Platypus::Nomore::Program>()
{
    ProgramFactory::instance().add("nomore", &create);
}

}   // end namespace Platypus
