// $Id: test_smodels.cpp 2206 2005-07-18 12:04:28Z jgressma $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <set>
#include <cstring>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/program_metadata.h>
#include <test/smodels_helper.h>
#include <smodels/smodels.h>
#include <smodels/read.h>
#include <smodels/api.h>
#include <smodels/atomrule.h>

using namespace std;


// These test cases certify that smodels really behaves
// as we assume in the interface implementation

class SmodelsTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
public:
	SmodelsTest()
	{
		cout << "This tests the statically linked smodels code!" << endl;
		metaData_ = &ProgramMetaData::instance();
	}
	
	void testContradictionComputesYieldNoAnswerSet()
	{
		const MetaData& md = metaData_->get("usualcases.lparse");
		ifstream in(md.filename_.c_str());
		CPPUNIT_ASSERT(in);

		Smodels smodels;
		Api api(&smodels.program);
		Read reader(&smodels.program, &api);
		int bad = reader.read(in);
		CPPUNIT_ASSERT_EQUAL(bad, 0);

		// set both a to true and false manually
		Atom* a = 0;
        for (Node *n = smodels.program.atoms.head (); n; n = n->next)
		{
			Atom *atom = n->atom;
			if(atom->name && strcmp(atom->name, "a") == 0)
			{	
				a = atom;
				break;
			}
		}  
		
		api.set_compute(a, true);
		api.set_compute(a, false);
		api.done();
		smodels.init();

		int modelCount = 0;
		while(smodels.model())
			++modelCount;

		CPPUNIT_ASSERT_EQUAL(modelCount, 0);
	}

	void testMultipleTimesSameComputeStatement()
	{
		const MetaData& md = metaData_->get("usualcases.lparse");
		ifstream in(md.filename_.c_str());
		CPPUNIT_ASSERT(in);

		Smodels smodels;
		Api api(&smodels.program);
		Read reader(&smodels.program, &api);
		int bad = reader.read(in);
		CPPUNIT_ASSERT_EQUAL(bad, 0);

		// set both a to true and false manually
		Atom* a = 0;
        for (Node *n = smodels.program.atoms.head (); n; n = n->next)
		{
			Atom *atom = n->atom;
			if(atom->name && strcmp(atom->name, "a") == 0)
			{	
				a = atom;
				break;
			}
		}  
		
		api.set_compute(a, false);
		api.set_compute(a, false);
		api.set_compute(a, false);
		api.done();
		smodels.init();

		int modelCount = 0;
		while(smodels.model())
			++modelCount;

		CPPUNIT_ASSERT_EQUAL(modelCount, 0);
	}
	void dualCalc(const char* filename, const char* checkagainst = 0)
	{
		ifstream in(filename);
		CPPUNIT_ASSERT(in);

		Smodels smodels1, smodels2;
		Api api1(&smodels1.program);
		Api api2(&smodels2.program);
		Read reader(&smodels1.program, &api1);
		int bad = reader.read(in);
		CPPUNIT_ASSERT_EQUAL(bad, 0);

		// copy over api
		api2.copy(&api1);

		api1.done();
		smodels1.init();
		api2.done();
		smodels2.init();

		stringstream s1, s2;
		s1 << smodels1;
		s2 << smodels2;
		string result = s1.str();
		CPPUNIT_ASSERT_EQUAL(true, answerSetCompare(s1, s2));

		
		if(checkagainst)
		{

			stringstream s(result);
			ifstream check(checkagainst);
			CPPUNIT_ASSERT(check);

			if(0)
			{
				ofstream out("result.txt");
				CPPUNIT_ASSERT(out);
				out << result;
				out.close();
			}

			CPPUNIT_ASSERT(answerSetCompare(s, check));
		}
	}
	void testUsualcases()
	{
		dualCalc("usualcases.lparse", "usualcases.lparse.smodels");
	}
	void testSchur()
	{
		dualCalc("schur-3-3.lparse", "schur-3-3.lparse.smodels");
		dualCalc("schur-6-3.lparse", "schur-6-3.lparse.smodels");
	}
	void testColor3_4()
	{
		dualCalc("color-3-4.lparse", "color-3-4.lparse.smodels");
	}
	void testHam_comp()
	{
		dualCalc("ham_comp_3.lparse", "ham_comp_3.lparse.smodels");
		dualCalc("ham_comp_4.lparse", "ham_comp_4.lparse.smodels");
		dualCalc("ham_comp_5.lparse", "ham_comp_5.lparse.smodels");
	}
	void testQueens()
	{
		dualCalc("4queens.lparse", "4queens.lparse.smodels");
		dualCalc("5queens.lparse", "5queens.lparse.smodels");
	}
	void testRealChoice()
	{
		dualCalc("realchoice1.lparse", "realchoice1.lparse.smodels");
		dualCalc("realchoice2.lparse", "realchoice2.lparse.smodels");
		dualCalc("realchoice3.lparse", "realchoice3.lparse.smodels");
	}
	void testApiCopyYieldsSameAnswerSets()
	{
		testUsualcases();
		testSchur();
		testColor3_4();
		testHam_comp();
		testQueens();
		testRealChoice();
	}

	CPPUNIT_TEST_SUITE( SmodelsTest );
		CPPUNIT_TEST( testContradictionComputesYieldNoAnswerSet );
		CPPUNIT_TEST( testMultipleTimesSameComputeStatement );
		CPPUNIT_TEST( testApiCopyYieldsSameAnswerSets );
		
		CPPUNIT_TEST( testUsualcases );	
		CPPUNIT_TEST( testSchur );
		CPPUNIT_TEST( testColor3_4 );
		CPPUNIT_TEST( testHam_comp );
		CPPUNIT_TEST( testQueens );
		CPPUNIT_TEST( testRealChoice );
		
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( SmodelsTest );


