#include <xplib/xplib-dll.h>
#include <platypus/factories/distribution_factory.h>
#include <platypus/utility/options_faker.h>
#include <program_options/value.h>
#include <distribution/mpi/mpi_platypus.h>

using namespace Platypus;

static unsigned counter = 0;

XPLIB_DLL_EXPORT void platypus_dll_initialize()
{
	if(counter++ == 0)
	{
		DistributionFactory::instance().add("mpi", PlatypusMPI::create, "Distribution via mpi");
		OptionsFaker::instance().options().addOptions()
			("verbose,v", ProgramOptions::bool_switch()->defaultValue(false), "print both master and worker statistics in mpi mode");
	}	
}

XPLIB_DLL_EXPORT void platypus_dll_finalize()
{}





