#include <mpi_statistics.h>
#include <iostream>

namespace Platypus
{
  
  MPIStatistics::MPIStatistics()
    :   indices_(0)
    ,   totalMessagesSent_(0)
    ,   totalMessagesReceived_(0)
    ,   totalExpanderInits_(0)
    ,   totalConflicts_(0)
    ,   totalModels_(0)
    ,   totalBacktracks_(0)
    ,   totalThreadDelegations_(0)
    ,   totalWorkRequestsToMaster_(0)
    ,   totalWorkRequestsFromMaster_(0)
    ,   totalWorkDenials_(0)
    ,   totalDelegationsToMaster_(0)
    ,   totalDelegationsFromMaster_(0)
    ,   totalDroppedRequests_(0)
    ,   answers_(0)
    ,   maxQueueSize_(0)
    ,   maxFiledWorkers_(0)
  {}
  
  MPIStatistics::~MPIStatistics()
  {}

  void MPIStatistics::setup(unsigned indices)
  {

    indices_ = indices;

    messagesSent_.resize(indices_, 0);
    messagesReceived_.resize(indices_, 0);
    expanderInits_.resize(indices_, 0);
    conflicts_.resize(indices_, 0);
    models_.resize(indices_, 0);
    backtracks_.resize(indices_, 0);
    threadDelegations_.resize(indices_, 0);
    workRequestsToMaster_.resize(indices_, 0);
    workRequestsFromMaster_.resize(indices_, 0);
    workDenials_.resize(indices_, 0);
    delegationsToMaster_.resize(indices_, 0);
    delegationsFromMaster_.resize(indices_, 0);
    droppedRequests_.resize(indices_, 0);

  }

  void MPIStatistics::incMessagesSent(unsigned index, unsigned long inc)
  {
    messagesSent_.at(index) += inc;
    totalMessagesSent_ += inc; 
  }

  void MPIStatistics::incMessagesReceived(unsigned index, unsigned long inc)
  {
    
    messagesReceived_.at(index) += inc;
    totalMessagesReceived_ += inc;
  }

  void MPIStatistics::incExpanderInits(unsigned index, unsigned long inc)
  {
    expanderInits_.at(index) += inc;
    totalExpanderInits_ += inc;
  }

  void MPIStatistics::incConflicts(unsigned index, unsigned long inc)
  {
    conflicts_.at(index) += inc;
    totalConflicts_ += inc;
  }  

  void MPIStatistics::incModels(unsigned index, unsigned long inc)
  {
    models_.at(index) += inc;
    totalModels_ += inc;
  }  

  void MPIStatistics::incBacktracks(unsigned index, unsigned long inc)
  {
    backtracks_.at(index) += inc;
    totalBacktracks_ += inc;
  }  

  void MPIStatistics::incThreadDelegations(unsigned index, unsigned long inc)
  {
    threadDelegations_.at(index) += inc;
    totalThreadDelegations_ += inc;
  }  

  void MPIStatistics::incWorkRequestsToMaster(unsigned index, unsigned long inc)
  { 
    workRequestsToMaster_.at(index) += inc;
    totalWorkRequestsToMaster_ += inc;
  }

  void MPIStatistics::incWorkRequestsFromMaster(unsigned index, unsigned long inc)
  { 
    workRequestsFromMaster_.at(index) += inc;
    totalWorkRequestsFromMaster_ += inc;
  }

  void MPIStatistics::incWorkDenials(unsigned index, unsigned long inc)
  {
    workDenials_.at(index) += inc;
    totalWorkDenials_ += inc;
  }

  void MPIStatistics::incWorkDelegationsToMaster(unsigned index, unsigned long inc)
  {
    delegationsToMaster_.at(index) += inc;
    totalDelegationsToMaster_ += inc;
  }

  void MPIStatistics::incWorkDelegationsFromMaster(unsigned index, unsigned long inc)
  {
    delegationsFromMaster_.at(index) += inc;
    totalDelegationsFromMaster_ += inc;
  }

  void MPIStatistics::incDroppedRequests(unsigned index, unsigned long inc)
  {
    droppedRequests_.at(index) += inc;
    totalDroppedRequests_ += inc;
  }

  unsigned long MPIStatistics::messagesSent() const
  {
    return totalMessagesSent_;
  }

  unsigned long MPIStatistics::messagesReceived() const
  {
    return totalMessagesReceived_;
  }

  unsigned long MPIStatistics::expanderInits() const
  {
    return totalExpanderInits_;
  }  

  unsigned long MPIStatistics::conflicts() const
  {
    return totalConflicts_;
  }  

  unsigned long MPIStatistics::models() const
  {
    return totalModels_;
  }  

  unsigned long MPIStatistics::backtracks() const
  {
    return totalBacktracks_;
  }  

  unsigned long MPIStatistics::threadDelegations() const
  {
    return totalThreadDelegations_;
  }  

  unsigned long MPIStatistics::workRequestsToMaster() const
  {
    return totalWorkRequestsToMaster_;
  }

  unsigned long MPIStatistics::workRequestsFromMaster() const
  {
    return totalWorkRequestsFromMaster_;
  }

  unsigned long MPIStatistics::workDenials() const
  {
    return totalWorkDenials_;
  }

  unsigned long MPIStatistics::workDelegationsToMaster() const
  {
    return totalDelegationsToMaster_;
  }

  unsigned long MPIStatistics::workDelegationsFromMaster() const
  {
    return totalDelegationsFromMaster_;
  }

  unsigned long MPIStatistics::droppedRequests() const
  {
    return totalDroppedRequests_;
  }


  unsigned long MPIStatistics::indexMessagesSent(unsigned index) const
  {   
    return messagesSent_.at(index);
  }

  unsigned long MPIStatistics::indexMessagesReceived(unsigned index) const
  {    
    return messagesReceived_.at(index);
  }
 
  unsigned long MPIStatistics::indexExpanderInits(unsigned index) const
  {
    return expanderInits_.at(index);
  }  

  unsigned long MPIStatistics::indexConflicts(unsigned index) const
  {
    return conflicts_.at(index);
  }  

  unsigned long MPIStatistics::indexModels(unsigned index) const
  {
    return models_.at(index);
  }  

  unsigned long MPIStatistics::indexBacktracks(unsigned index) const
  {
    return backtracks_.at(index);
  }  

  unsigned long MPIStatistics::indexThreadDelegations(unsigned index) const
  {
    return threadDelegations_.at(index);
  }

  unsigned long MPIStatistics::indexWorkRequestsToMaster(unsigned index) const
  { 
    return workRequestsToMaster_.at(index);
  }

  unsigned long MPIStatistics::indexWorkRequestsFromMaster(unsigned index) const
 { 
    return workRequestsFromMaster_.at(index);
  }

  unsigned long MPIStatistics::indexWorkDenials(unsigned index) const
  {
    return workDenials_.at(index);
  }

  unsigned long MPIStatistics::indexWorkDelegationsToMaster(unsigned index) const
  {
    return delegationsToMaster_.at(index);
  }

  unsigned long MPIStatistics::indexWorkDelegationsFromMaster(unsigned index) const
  {
    return delegationsFromMaster_.at(index);
  }

  unsigned long MPIStatistics::indexDroppedRequests(unsigned index) const
  {
    return droppedRequests_.at(index);
  }

  void MPIStatistics::checkMaxQueueSize(unsigned queueSize)
  {
    if(queueSize > maxQueueSize_)
      maxQueueSize_ = queueSize;
  }

  unsigned MPIStatistics::maxQueueSize() const
  {
    return maxQueueSize_;
  }

  void MPIStatistics::checkMaxFiledWorkers(unsigned filedWorkers)
  {
    if(filedWorkers > maxFiledWorkers_)
      {
	maxFiledWorkers_ = filedWorkers;
      }
  }
  unsigned MPIStatistics::maxFiledWorkers()
  {
    return maxFiledWorkers_;
  }

}

