/*	$Id: multi_threaded_core.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef MULTI_THREADED_CORE_H
#define MULTI_THREADED_CORE_H

#include <string>
#include <memory>
#include <platypus/core_base.h>
#include <platypus/types_fwd.h>

class NopStream;
namespace Platypus
{
	class Foreman;
	class ForemanAssistant;
	class MultiThreadedCore	: public CoreBase
	{
	public:
		~MultiThreadedCore();
		MultiThreadedCore();
		static CoreBase* create();
	public: // BuilderCoreCallback
		void program(ProgramInterface& prog);
		void distribution(CoreDistributionCallback& callback);
		void factory(const PlatypusTypesFactory& factory);
		void output(NopStream& str);
		void options(const PlatypusOptions& values);
		void setup();
	public: // PlatypusAlgorithmCoreCallback
		const std::string& type() const;
		void run();
	private:
		std::auto_ptr<Foreman> foreman_;
		std::auto_ptr<ForemanAssistant> assistant_;

		static const std::string type_;
	};
}

#endif
