/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef BUILD_FLAGS_H
#define BUILD_FLAGS_H

#include <string>
#include <set>

class Aliases
{
	typedef std::set<std::string> AliasList;
public:
	enum OS
	{
		UNKNOWN_OS,
		LINUX,
		SOLARIS,
		MINGW32,
		FREEBSD,
		DARWIN
	};
	enum CPU
	{
		UNKNOWN_CPU,
		PENTIUM,
		AMD64,
		V9,
		V8,
		IA64,
		PPC
	};
public:
	Aliases();
	OS findClosestCannonicalOS(const std::string& cs) const;
	CPU findClosestCannonicalCPU(const std::string& cs) const;
	bool doesCPUSupport64Bits(const std::string& cs) const;
private:
	// os
	AliasList Linux, Solaris, Mingw32, FreeBSD, Darwin;
	// arch
	AliasList Pentium, Amd64, UltrasSPARC, SPARC, Ia64, PowerPC;
private:
	static const char* CannonicalLinux;
	static const char* CannonicalSolaris;
	static const char* CannonicalMingw32;
	static const char* CannonicalFreeBSD;
	static const char* CannonicalDarwin;

	static const char* CannonicalAMD64;
	static const char* CannonicalV9;
	static const char* CannonicalV8;
	static const char* CannonicalV8Plus;
	static const char* CannonicalIA64;
	static const char* CannonicalPentium;
	static const char* CannonicalPowerPC;
};

class BuildFlags
{
public:
	BuildFlags();
	const std::string& getDefines() const;
	const std::string& getCXXFlags() const;
	const std::string& getLDFlags() const;
	const std::string& getLibraries() const;
	Aliases::CPU getCPU() const;
	Aliases::OS getOS() const;
	bool isConfigurationSupported() const;
	void setGNUBuildString(const std::string& s);
	void setWidth(unsigned width);
	void setDetectWidth(bool b);
private:
	void configure();
private:
	std::string gnuBuildString_, defines_, cxxflags_, ldflags_, libs_;
	unsigned width_;
	Aliases::CPU cannonicalCPU_;
	Aliases::OS cannonicalOS_;
	bool detectWidth_, supported_;
private:
	static const Aliases aliases_;
};	

#endif

