// ProgramOptions (Alpha-Version) (c) Benjamin Kaufmann 
// ProgramOptions is a scaled-down version of boost::program_options
// see: http://boost-sandbox.sourceforge.net/program_options/html/

#include "value.h"
#include "my_ctype.h"
#include "string_functions.h"
#include <algorithm>
#include <strstream>
using namespace std;
namespace {
	std::string checkSingleValue(const std::string& s, bool allowEmpty)
	{
		if (s.empty() && !allowEmpty)
			throw ProgramOptions::BadValue("at least one value required");
		string copy(s);
		StringFunctions::trimLeft(copy, "\t\n ");
		StringFunctions::trimRight(copy, "\t\n ");
		if (copy.find_first_of("\t\n ") != string::npos)
			throw ProgramOptions::BadValue("multiple values not allowed");
		return copy;
	}
}
namespace ProgramOptions {


bool parseValue(const std::string& s, bool& b)
{
	string copy = checkSingleValue(s, true);
	transform(copy.begin(), copy.end(), copy.begin(), toLower);
	if (copy.empty() || copy == "true" || copy == "1" || copy == "yes" || copy == "on")
	{
		b = true;
		return true;
	}
	if (copy == "false" || copy == "0" || copy == "no" || copy == "off")
	{
		b = false;
		return true;
	}
	throw BadValue(s + " is not a valid bool value");
}

bool parseValue(const std::string& s, char& c)
{
	string copy = checkSingleValue(s, false);
	if (s.length() > 1)
		throw BadValue(s + " is not valid character value");
	c = s[0];
	return true;
}
bool parseValue(const std::string& s, double& d)
{
	char buffer[30];
	strstream str(buffer, 30);
	str << checkSingleValue(s, false) << ends;
	str >> d;
	if (str.eof() || str.good())
		return true;
	throw BadValue(s + " is not a valid double value");
}

bool parseValue(const std::string& s, float& f)
{
	double temp;
	parseValue(s, temp);
	f = static_cast<float>(temp);
	return true;
}

bool parseValue(const std::string& s, int& i)
{
	double temp;
	parseValue(s, temp);
	i = static_cast<int>(temp);
	return true;
}

bool parseValue(const std::string& s, std::string& str)
{
	str = checkSingleValue(s, false);
	return true;
}

std::string writeValue(bool b)
{
	return b ? "true" : "false";
}

std::string writeValue(char c)
{
	return std::string(1, c);
}

std::string writeValue(double d)
{
	char buffer[30];
	strstream s(buffer, 30);
	s << d << ends;
	return s.str();
}
std::string writeValue(float f)
{
	return writeValue(static_cast<double>(f));
}
std::string writeValue(int i)
{
	return writeValue(static_cast<double>(i));
}
std::string writeValue(const std::string& s)
{
	return s;
}

Value<bool>* bool_switch(bool* b)
{
	Value<bool>* nv = new Value<bool>(b);
	nv->setImplicit();
	return nv;
}
}

