/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef PPC_MUXER_H
#define PPC_MUXER_H

#include <cassert>

namespace PortableThreads 
{
	namespace LockFree
	{
		// Nothing is known about the layout of a VA, however, as PowerPC provides LL/SC we 
		// don't need to :)
		namespace Private
		{
			template<
				typename T, 
				unsigned ALIGNMENT_BITS = 0,
				unsigned USER_BITS = 0
			>
			struct PPCMuxer
			{
				enum __dummy 
				{ 
					POINTER_BITS = sizeof(T)*8, 
					HAVE_USER_BITS = USER_BITS > 0
				};
				typedef T int_t;
				typedef token_t<false, HAVE_USER_BITS> token_t;
				static inline int_t multiplex(int_t pointer, int_t userbits)
				{
					assert(ALIGNMENT_BITS - USER_BITS >= 0);						

					// Make sure the aligment assumption holds
					assert((pointer & ALIGNMENT_MASK) == 0);

					// Make sure user bits don't occupy anything else
					assert((userbits & ~USER_BITS_MASK) == 0);

					if(HAVE_USER_BITS) // compiler optimizes this away...
						pointer ^= userbits;

					return pointer;
				}
				static inline int_t userbits(int_t mux)
				{
					return mux & USER_BITS_MASK;
				}
				static inline int_t count(int_t)
				{
					return 0;
				}
				static inline int_t pointer(int_t mux)
				{
					return mux & (~USER_BITS_MASK);
				}
				static inline int_t pointerBits()
				{
					return POINTER_BITS;
				}
				static inline int_t alignmentBits()
				{
					return ALIGNMENT_BITS;
				}
				static inline int_t userBits()
				{
					return USER_BITS;
				}
			private:
				static const int_t USER_BITS_MASK = (static_cast<int_t>(1) << USER_BITS) - 1;
				static const int_t ALIGNMENT_MASK = (static_cast<int_t>(1) << ALIGNMENT_BITS) - 1;
			};
		}
	}
}

#endif
