/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef SPARC_V8_GCC_COMMON_H
#define SPARC_V8_GCC_COMMON_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif


namespace PortableThreads 
{
	// Assembler functions are straight from the linux kernel
	// NOTE: Appearently the pre v8plus architectures don't have 
	// even have simple cas (not to mention cas2)
	// SPARC V8 is a 32-bit CPU with 32-bit addressing!
	namespace LockFree
	{
		namespace Private
		{
			inline int32 pt_atomic_set(volatile int32* mem, int32 val)
			{
				__asm__ __volatile__
					(
					"swap [%2], %0 \n\t"
					: "=&r" (val)
					: "0" (val), "r" (mem)
					: "memory"
					);
				return val;
			}

			typedef uint8 spinlock_t;
			inline bool pt_atomic_set_lock(volatile spinlock_t* lock)
			{
				uint32 result;
				__asm__ __volatile__
					(
					"ldstub [%1], %0 \n\t"
					: "=r" (result)
					: "r" (lock)
					: "memory"
					);
				return result == 0;
			}

			inline void pt_atomic_clear_lock(volatile spinlock_t* lock)
			{
				__asm__ __volatile__("stb %%g0, [%0] \n\t" : : "r"(lock) : "memory");
			}
		}
	}
}

#endif
