/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef PT_MEMORY_CHUNK_MANAGER_H
#define PT_MEMORY_CHUNK_MANAGER_H

#include <portablethreads/config.h>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			class PTMemoryChunkManager
			{
			public:
				~PTMemoryChunkManager();
				PTMemoryChunkManager(pt_uint_t ChunkSize);
				void* acquireChunk();
				void releaseChunk(void* Chunk);
				static void setUserDataOnChunk(void* Chunk, unsigned);
				static unsigned getUserDataFromChunk(void* Chunk);
				static void createFakeChunkHeader(void* mem);
				static unsigned getChunkHeaderSize();
			private: // manager implementation
				void freeBatchesToSystem();
				void* allocFromNewBatch();
			private: // lf queue implementation
				void pushBackAllocating(void* p);
				bool popFrontAllocating(void*& p);
				void pushBackFreeing(void* p);
				bool popFrontFreeing(void*& p);
				void pushBack(PTPointerLLSC& Tail, void* p);
				bool popFront(PTPointerLLSC& Head, PTPointerLLSC& Tail, void*& p);
			private:
				PTMemoryChunkManager();
				PTMemoryChunkManager(PTMemoryChunkManager&);
				PTMemoryChunkManager& operator=(PTMemoryChunkManager&);
			private:
				pt_uint_t pagesPerBatch_, chunkSize_;
				PTPointerLLSC allocatingQueueHead_, allocatingQueueTail_, freeingQueueHead_, freeingQueueTail_;
			private:
				class NodeManager;
				static NodeManager* nodeManager_;
			};
		}
	}
}

#endif // PT_MEMORY_CHUNK_QUEUE_H
