/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <cassert>
#include <cstring>
#include <cstdio>

namespace PortableThreads
{
	unsigned pt_pagesize()
	{
		static const unsigned PAGESIZE = sysconf(_SC_PAGESIZE);
		return PAGESIZE;
	}

	void* pt_mmap(unsigned long pages)
	{
#if defined(PT_DARWIN)
		void* res = mmap(0, pages * pt_pagesize(), PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANON | MAP_HASSEMAPHORE, -1, 0);
		return res == reinterpret_cast<void*>(-1) ? 0 : res;
#else
		const int dev_zero_fd = open("/dev/zero", O_RDWR);
		assert(dev_zero_fd != -1);
		void* res = mmap(0, pages * pt_pagesize(), PROT_READ | PROT_WRITE, MAP_PRIVATE, dev_zero_fd, 0);
		// mmap is required to keep the file open so we can close it
		close(dev_zero_fd);		
		return res == MAP_FAILED ? 0 : res;
#endif
	}


	void pt_munmap(void* memory, unsigned long pages)
	{
		munmap(memory, pages * pt_pagesize());
	}
}

