/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
 
#ifndef UNIX_MUTEX_H
#define UNIX_MUTEX_H
#include <portablethreads/config.h>
#include <portablethreads/exception.h>
#include <pthread.h>

namespace PortableThreads 
{
	namespace OSSpecific
	{
		class PTMutex
		{
		public:
			PTMutex(bool locked = false) 		
			{
				if(pthread_mutex_init(&mutex_, 0) != 0)
					throw PTResourceError("[PTMutex] Could not create mutex variable");
				if(locked)
					lock();
			}	
			~PTMutex()
			{
				pthread_mutex_destroy(&mutex_);
			}
			inline bool tryLock() 
			{ 
				return pthread_mutex_trylock(&mutex_) == 0;		
			}
			inline void lock() 
			{ 
				while(pthread_mutex_lock(&mutex_) != 0); 
			}
			inline void unlock() 
			{ 
				// ok, only error according to Single Unix Spec is EPERM
				pthread_mutex_unlock(&mutex_); 
			}
		private:
			PTMutex(const PTMutex&);
			PTMutex& operator=(const PTMutex&);
		private:
			pthread_mutex_t mutex_;
		};
	}
}

#endif
