/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <cassert>

namespace PortableThreads
{

	// These functions are mostly due to Doug Lea's malloc implementation
	static unsigned pt_get_pagesize()
	{
		SYSTEM_INFO system_info;
		GetSystemInfo(&system_info);
		return static_cast<unsigned>(system_info.dwPageSize);
	}

	unsigned pt_pagesize()
	{
		static const unsigned PAGESIZE = pt_get_pagesize();
		return PAGESIZE;
	}

	void* pt_mmap(unsigned long pages) 
	{
		void* p;
		do
		{
			p = VirtualAlloc(0, pages * pt_pagesize(), MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
		}
		while(!p);
		return p;
	}

	void pt_munmap(void* ptr, unsigned long) 
	{
		VirtualFree(ptr, 0, MEM_RELEASE);		
	}
}


