/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
 
#ifndef WIN32_MUTEX_H
#define WIN32_MUTEX_H
#include <portablethreads/config.h>
#include <portablethreads/exception.h>
#include <windows.h>

namespace PortableThreads 
{
	namespace OSSpecific
	{
		class PTMutex
		{
		public:
			~PTMutex()
			{
				CloseHandle(mutex_);
			}
			// create a mutex. Default constructor creates unlocked mutex
			PTMutex(bool locked = false) 
				:	mutex_(locked ? CreateSemaphore(0, 0, 1, 0) : CreateSemaphore(0, 1, 1, 0))
			{
				if(mutex_ == NULL)
					throw PTResourceError("[PTMutex] Could not create semaphore");
			}
		  	// try to lock the mutex. Returns true on success, false otherwise
			inline bool tryLock()
  			{
      			return WaitForSingleObject(mutex_, 0) == WAIT_OBJECT_0;			
			}
			// lock the mutex. If the mutex is currently locked block till it unlocks
			inline void lock()
  			{
    			while(WaitForSingleObject(mutex_, INFINITE) != WAIT_OBJECT_0);
			}
			// unlock the mutex. This is a noop if the mutex is unlocked
			inline void unlock()
  			{
    			ReleaseSemaphore(mutex_, 1, 0);    		
  			}		
		private:
			// Mutexes cannot be copied or assigned
			PTMutex(const PTMutex&);
  			PTMutex& operator=(const PTMutex&);
		private:
			HANDLE mutex_;
		};
	}
}



#endif
