/*
Copyright (c) 2006, Jean Gressmann All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * 	Redistributions of source code must retain the above copyright
    	notice, this list of conditions and the following disclaimer. 
    *	Redistributions in binary form must reproduce the above copyright
		notice, this list of conditions and the following disclaimer in the
		documentation and/or other materials provided with the distribution.
    * 	The names of its contributors may not be used to endorse or promote products
		derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
 
#include <limits>
#include <cassert>
#include <windows.h>

#ifdef max
#	undef max
#endif

#ifdef _MSC_VER
#	pragma warning(disable:4244) // uint64 -> unsigned conversion
#endif

namespace PortableThreads 
{
	void pt_second_sleep(unsigned time)
	{
		uint64 t = static_cast<uint64>(time) * 1000;
		while(t > static_cast<uint64>(std::numeric_limits<DWORD>::max()))
		{
			t -= std::numeric_limits<DWORD>::max();
			Sleep(std::numeric_limits<DWORD>::max());
		}
		Sleep(t);
	}
	void pt_milli_sleep(unsigned time)
	{
		if(time > std::numeric_limits<DWORD>::max())
		{
			time -= std::numeric_limits<DWORD>::max();
			Sleep(std::numeric_limits<DWORD>::max());
		}
		Sleep(time);
	}
	void pt_micro_sleep(unsigned time)
	{
		const PTime::time_type start = (PTime::now() * PTime::frequency()) / 1000000;

		PTime::time_type msToSleep = time / 1000;
		pt_milli_sleep(msToSleep);

		for(PTime::time_type now = (PTime::now() * PTime::frequency()) / 1000000;
			start + now < time; now  = (PTime::now() * PTime::frequency()) / 1000000)
		{
			Sleep(0);
		}
	}

	void pt_yield()
	{
		Sleep(0);
	}

	///////////////////////////////////////////////////////////////////////
	// Time
	///////////////////////////////////////////////////////////////////////
	PTime::time_type PTime::now()
	{
		FILETIME ft;
		GetSystemTimeAsFileTime(&ft);
		ULARGE_INTEGER i;
		i.HighPart = ft.dwHighDateTime;
		i.LowPart = ft.dwHighDateTime;
		return static_cast<PTime::time_type>(i.QuadPart);
	}

	PTime::time_type PTime::calculateFrequency()
	{
		return 1000;
	}
	const PTime::time_type PTime::frequency_ = PTime::calculateFrequency();
}

#ifdef _MSC_VER
#	pragma warning(disable:4244) // uint64 -> unsigned conversion
#endif


