#include <iostream>
#include <cstring>
#include <ctime>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/extensions/HelperMacros.h>


#ifdef _MSC_VER
	#include <crtdbg.h>
#endif

using namespace std;

int main(int argc, char* argv[])
{
#ifdef _MSC_VER
	if(1)
	{
		_CrtSetDbgFlag(_CrtSetDbgFlag(_CRTDBG_REPORT_FLAG) | _CRTDBG_LEAK_CHECK_DF |
			_CRTDBG_ALLOC_MEM_DF | _CRTDBG_CHECK_ALWAYS_DF);
		_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_WARN, _CRTDBG_FILE_STDERR );
		_CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDERR );
		_CrtSetReportMode( _CRT_ASSERT, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ASSERT, _CRTDBG_FILE_STDERR );
	}
#endif

	unsigned count = 1;
	if(argc == 2)
	{
		if(strcmp(argv[1], "0") == 0)
		{
			count = (unsigned)-1;
		}
		else
		{
			count = atoi(argv[1]);
		}
	}

	CppUnit::TextUi::TestRunner runner;
	CppUnit::TestFactoryRegistry &registry = CppUnit::TestFactoryRegistry::getRegistry();
	runner.addTest( registry.makeTest() );
	
	const clock_t tv1 = clock();
	for(unsigned i = 0; i < count; ++i)
		runner.run();
	

	const clock_t tv2 = clock();
    const double time = tv2 / (CLOCKS_PER_SEC * 1.0) - tv1 / (CLOCKS_PER_SEC * 1.0);

	cout << "total time: " << time << endl;
	return 0;
}
