
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/thread.h>
#include <portablethreads/time.h>
#include <portablethreads/barrier.h>



using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

namespace
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			CPPUNIT_ASSERT(false && "no exception excepted");
		}
	};
	class Thread0 : public ThreadBase
	{
	public:
		Thread0(volatile bool& f, PTBarrier& b)
			:	flag_(&f)
			,	barrier_(&b)
		{}	
	private:
		void threadMain()
		{
			CPPUNIT_ASSERT_EQUAL(true, barrier_->wait());
			*flag_ = true;
		}
	private:
		volatile bool* flag_;
		PTBarrier* barrier_;
	};

}

class BarrierTest : public CppUnit::TestFixture
{
public:
	void testDry()
	{
		PTBarrier b(1);

		CPPUNIT_ASSERT_EQUAL(true, b.wait());
	}
	void testLoopingWait()
	{
		volatile bool f = false;
		volatile bool check = false;
		const unsigned t = 8;
		PTBarrier b(t+1);

		vector<Thread0*> threads(t);
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i] = new Thread0(f, b);
			threads[i]->run();
		}

		CPPUNIT_ASSERT_EQUAL(check, f);
		CPPUNIT_ASSERT_EQUAL(true, b.wait());

		for(unsigned i = 0; i < t; ++i)
		{
			threads[i]->join();
			delete threads[i];
		}

		check = true;
		CPPUNIT_ASSERT_EQUAL(check, f);		
	}
	CPPUNIT_TEST_SUITE( BarrierTest );
		CPPUNIT_TEST( testDry );
		CPPUNIT_TEST( testLoopingWait );
	CPPUNIT_TEST_SUITE_END();
};


//CPPUNIT_TEST_SUITE_REGISTRATION( BarrierTest );



