#include <vector>
#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/thread.h>
#include <portablethreads/lockfree/queue.h>



using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

namespace
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			CPPUNIT_ASSERT(false && "no exception excepted");
		}
	};

	typedef PTQueue<unsigned> Queue;
	typedef vector<unsigned> Vector;
		

	class Thread0 : public ThreadBase
	{
	public:
		Thread0(volatile bool& flag, Queue& n, unsigned count)
			:	queue_(&n)
			,	count_(count)
			,	flag_(&flag)
			,	sum_(0)
		{}
		unsigned sum() const { return sum_; }
	private:
		void threadMain()
		{
			while(!*flag_)
				give();
			for(unsigned i = 0; i < count_; ++i)
			{
				queue_->pushBack(i);
			}

			for(unsigned x = 0; queue_->popFront(x); x = 0)
			{
				assert(x < count_);
				sum_ += x;
			}
			PortableThreads::LockFree::Private::pt_mfence();
		}
	private:
		Queue* queue_;
		unsigned count_;
		volatile bool* flag_;
		volatile unsigned sum_;
	};
}

class LockFreeQueueTest : public CppUnit::TestFixture
{
public:
	void testDry()
	{
		Queue s;
		Vector v;
		unsigned count = 80000;

		Queue::value_type x = 0;
		CPPUNIT_ASSERT_EQUAL(false, s.popFront(x));

		for(unsigned i = 0; i < count; ++i)
		{
			s.pushBack(i);
			v.push_back(i);
		}

		Vector::iterator vit = v.begin();
		for(Queue::iterator it = s.begin(), end = s.end();
			it != end;)
		{
			CPPUNIT_ASSERT_EQUAL(*vit, *it);
			++it;
			++vit;
		}


		for(unsigned i = 0; i < count; ++i)
		{
			x = 0;
			CPPUNIT_ASSERT_EQUAL(true, s.popFront(x));
			CPPUNIT_ASSERT_EQUAL(i, x);
		}
		CPPUNIT_ASSERT_EQUAL(false, s.popFront(x));

		v.clear();
		vit = v.begin();
		for(Queue::iterator it = s.begin(), end = s.end();
			it != end;)
		{
			CPPUNIT_ASSERT_EQUAL(*vit, *it);
			++it;
			++vit;
		}
	}
	void testBusy()
	{

		volatile bool flag = false;
		Queue q;
		const unsigned t = 8;
		const unsigned count = 10000;
		vector<Thread0*> threads(t);
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i] = new Thread0(flag, q, count);
			threads[i]->run();
		}

		unsigned x = 0;
		CPPUNIT_ASSERT_EQUAL(false, q.popFront(x));

		// off they go...
		flag = true;

		unsigned checksum = 0;
		for(unsigned i = 0; i < count; ++i)
		{
			checksum += i;
			if(checksum > (1<<30))
				cout << "Potential problem with sum" << endl;

		}
		checksum *= t;
		unsigned threadsum = 0;
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i]->join();
			threadsum += threads[i]->sum();
			delete threads[i];
		}

		CPPUNIT_ASSERT_EQUAL(false, q.popFront(x));
		CPPUNIT_ASSERT_EQUAL(checksum, threadsum);
	}
	
	CPPUNIT_TEST_SUITE( LockFreeQueueTest );
		CPPUNIT_TEST( testDry );
		CPPUNIT_TEST( testBusy );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( LockFreeQueueTest );



