#include <vector>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/thread.h>
#include <portablethreads/lockfree/stack.h>



using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

namespace
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			CPPUNIT_ASSERT(false && "no exception excepted");
		}
	};

	typedef PTStack<unsigned> Stack;
	typedef vector<unsigned> Vector;

	class Thread0 : public ThreadBase
	{
	public:
		Thread0(volatile bool& flag, Stack& n, unsigned count)
			:	stack_(&n)
			,	count_(count)
			,	flag_(&flag)
			,	sum_(0)
		{}
		unsigned sum() const { return sum_; }
	private:
		void threadMain()
		{
			while(!*flag_)
				give();
			for(unsigned i = 0; i < count_; ++i)
			{
				stack_->push(i);
			}

			for(unsigned x = 0; stack_->pop(x); x = 0)
			{
				assert(x < count_);
				sum_ += x;
			}
		}
	private:
		Stack* stack_;
		unsigned count_;
		volatile bool* flag_;
		unsigned sum_;
	};
}

class LockFreeStackTest : public CppUnit::TestFixture
{
public:
	void testDry()
	{
		Stack s;
		Vector v;
		unsigned count = 10;

		// no popping from empty stack
		Stack::value_type x = 0;
		CPPUNIT_ASSERT_EQUAL(false, s.pop(x));

		for(unsigned i = 0; i < count; ++i)
		{
			s.push(i);
			v.push_back(i);
		}

		Vector::reverse_iterator vit = v.rbegin();
		for(Stack::iterator it = s.begin(), end = s.end();
			it != end;)
		{
			CPPUNIT_ASSERT_EQUAL(*vit, *it);
			++it;
			++vit;
		}

		for(unsigned i = count; i > 0; --i)
		{
			x = 0;
			CPPUNIT_ASSERT_EQUAL(true, s.pop(x));
			CPPUNIT_ASSERT_EQUAL(i-1, x);
		}

		// no popping from empty stack
		CPPUNIT_ASSERT_EQUAL(false, s.pop(x));

		// no further iterations on empty stack
		v.clear();
		vit = v.rbegin();
		for(Stack::iterator it = s.begin(), end = s.end();
			it != end;)
		{
			CPPUNIT_ASSERT_EQUAL(*vit, *it);
			++it;
			++vit;
		}
	}
	void testBusy()
	{
		volatile bool flag = false;
		Stack s;
		const unsigned t = 8;
		const unsigned count = 10000;
		vector<Thread0*> threads(t);
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i] = new Thread0(flag, s, count);
			threads[i]->run();
		}

		unsigned x = 0;
		CPPUNIT_ASSERT_EQUAL(false, s.pop(x));

		// off they go...
		flag = true;

		unsigned checksum = 0;
		for(unsigned i = 0; i < count; ++i)
			checksum += i;
		
		checksum *= t;
		unsigned threadsum = 0;
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i]->join();
			threadsum += threads[i]->sum();
			delete threads[i];
		}

		CPPUNIT_ASSERT_EQUAL(false, s.pop(x));
		CPPUNIT_ASSERT_EQUAL(checksum, threadsum);
	}
	
	CPPUNIT_TEST_SUITE( LockFreeStackTest );
		CPPUNIT_TEST( testDry );
		CPPUNIT_TEST( testBusy );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( LockFreeStackTest );



