#include <vector>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/mmap.h>
#include <portablethreads/lockfree/memory_chunk_batch.h>
#include <cstring>

using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree::Private;

const char SEVENLETTERS[]  = "Hello !";

class MemoryChunkBatchTest : public CppUnit::TestFixture
{
public:
	void testCreateDestroyEmpty()
	{
		const int pages = 1;
		void* raw = pt_mmap(pages);
		pt_setup_memory_chunk_batch(raw, pages*pt_pagesize(), 16);
		pt_destroy_memory_chunk_batch(raw);

		pt_munmap(raw, pages);
	}
	void testMallocFreeNoWrite()
	{
		const int pages = 1;
		void* raw = pt_mmap(pages);
		pt_setup_memory_chunk_batch(raw, pages*pt_pagesize(), 16);
		void* p = pt_alloc_from_memory_chunk_batch(raw);
		pt_free_to_memory_chunk_batch(p);
		pt_destroy_memory_chunk_batch(raw);

		pt_munmap(raw, pages);
	}

	void testMallocWriteReadFree()
	{
		const int pages = 1;
		void* raw = pt_mmap(pages);
		pt_setup_memory_chunk_batch(raw, pages*pt_pagesize(), 8);
		void* p = pt_alloc_from_memory_chunk_batch(raw);

		CPPUNIT_ASSERT_EQUAL(true, pt_validate_write_to_memory_chunk(p, sizeof(SEVENLETTERS)));

		strcpy((char*)p, SEVENLETTERS);
		CPPUNIT_ASSERT_EQUAL(0, strcmp((char*)p, SEVENLETTERS));
		pt_free_to_memory_chunk_batch(p);
		pt_destroy_memory_chunk_batch(raw);

		pt_munmap(raw, pages);
	}
	void testMallocWriteReadFreeAll()
	{
		const int pages = 1;
		void* raw = pt_mmap(pages);
		pt_setup_memory_chunk_batch(raw, pages*pt_pagesize(), 8);
		
		vector<void*> buffer;
		for(void* p = pt_alloc_from_memory_chunk_batch(raw); p; p = pt_alloc_from_memory_chunk_batch(raw))
		{
			buffer.push_back(p);
			CPPUNIT_ASSERT_EQUAL(true, pt_validate_write_to_memory_chunk(p, sizeof(SEVENLETTERS)));
			strcpy((char*)p, "Hallo");
			CPPUNIT_ASSERT_EQUAL(0, strcmp((char*)p, "Hallo"));
		}
		void* p = pt_alloc_from_memory_chunk_batch(raw);

		while(!buffer.empty())
		{
			pt_free_to_memory_chunk_batch(buffer.back());
			buffer.pop_back();
		}
		pt_destroy_memory_chunk_batch(raw);
		pt_munmap(raw, pages);
	}
	CPPUNIT_TEST_SUITE( MemoryChunkBatchTest );
		CPPUNIT_TEST( testCreateDestroyEmpty );
		CPPUNIT_TEST( testMallocFreeNoWrite );
		CPPUNIT_TEST( testMallocWriteReadFree );
		CPPUNIT_TEST( testMallocWriteReadFreeAll );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( MemoryChunkBatchTest );



