#ifdef _MSC_VER
#	include <crtdbg.h>
#endif
#include <signal.h>
#include <iostream>
#include <cassert>
#include <vector>
#include <algorithm>
#include <functional>
#include <stdio.h>
#include <portablethreads/config.h>
#include <portablethreads/lock_free.h>
#include <portablethreads/thread.h>
#include <portablethreads/tls.h>
#include <portablethreads/semaphore.h>
#include <portablethreads/lockfree/memory_chunk_batch.h>

using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;




#include <portablethreads/time.h>
#include <portablethreads/mmap.h>




namespace MemoryChunk
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			assert(false && "no exception excepted");
		}
	};
	class Thread0 : public ThreadBase
	{
	public:
		Thread0(volatile bool& flag, unsigned id, void* managedChunk, size_t chunksize)
			:	flag_(&flag)
			,	id_(id)
			,	managedChunk_(managedChunk)
			,	chunkSize_(chunksize)
		{}	
	private:
		void threadMain()
		{
			char* buf = new char[chunkSize_];
			memset(buf, id_, chunkSize_);
			while(*flag_)
			{
				void* p = LockFree::Private::pt_alloc_from_memory_chunk_batch(managedChunk_);
				if(!p)
				{
					give();
					continue;
				}
				bool writeOK = LockFree::Private::pt_validate_write_to_memory_chunk(p, chunkSize_);
				assert(writeOK);
				memset(p, id_, chunkSize_);
				const int result = memcmp(p, buf, chunkSize_);
				if(result != 0)
					printf("Thread id %d had its allocated memory changed!\n", id_);

				LockFree::Private::pt_free_to_memory_chunk_batch(p);
			}

			delete [] buf;
		}
	private:
		volatile bool* flag_;
		unsigned id_;
		void* managedChunk_;
		size_t chunkSize_;
	};

	volatile bool run = true;
	void SignalHandler(int)
	{
		run = false;
	}

}


void testMemoryChunk()
{
	::signal (SIGINT, MemoryChunk::SignalHandler);
	::signal (SIGTERM, MemoryChunk::SignalHandler);
	

	unsigned t = 4;
	vector<MemoryChunk::Thread0*> threads(t);
	const size_t memsize = 1 << 12;
	const size_t pages = (memsize % pt_pagesize()) + 1;
	void* mem = pt_mmap(pages);
	size_t chunksize = 512;
	LockFree::Private::pt_setup_memory_chunk_batch(mem, memsize, chunksize);
	for(unsigned i = 0; i < t; ++i)
	{
		threads[i] = new MemoryChunk::Thread0(MemoryChunk::run, i, mem, chunksize);
		threads[i]->run();
	}

	
	for(unsigned i = 0; i < t; ++i)
	{
		threads[i]->join();
		delete threads[i];
	}

	pt_munmap(mem, pages);
}



void func()
{
	cout << "::func" << endl;
	//pt_second_sleep(5);
}

int gunc()
{
	cout << "::gunc" << endl;
	return 1;
}

int hunc(double)
{
	return 1;
}

class Foo
{
public:
	void func() {}
	int gunc() {return 0;}
	int hunc() const 
	{
		cout << PThreadRunner::self() << ", prio: " << PThreadRunner::getPriority() << '\n';
		cout << PThreadRunner::self() << ", setting prio to highest: " << PThreadRunner::setPriority(PThreadRunner::PRIO_HIGHEST) << '\n';
		cout << PThreadRunner::self() << ", setting prio to lowest: " << PThreadRunner::setPriority(PThreadRunner::PRIO_LOWEST) << '\n';
		
		PThreadRunner::give();

		return 0;
	}
	int punk(const char* p) { cout << p << endl; return 42; }
};

template<typename T>
	struct Dick
	{
		char raw[sizeof(T)];
		LockFree::Private::PTPointerLLSC next_;
	};


int main()
{
	cout.sync_with_stdio(false);
#ifdef _MSC_VER
	if(1)
	{
		_CrtSetDbgFlag(_CrtSetDbgFlag(_CRTDBG_REPORT_FLAG) |
			_CRTDBG_LEAK_CHECK_DF | _CRTDBG_ALLOC_MEM_DF |
			_CRTDBG_CHECK_ALWAYS_DF);
		_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_WARN, _CRTDBG_FILE_STDERR );
		_CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDERR );
		_CrtSetReportMode( _CRT_ASSERT, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ASSERT, _CRTDBG_FILE_STDERR );
	}
#endif

	void * pa = pt_mmap(1);
	pt_munmap(pa,1);
	
	PTMemoryHeap& processHeap = PTMemoryHeap::getProcessHeap();
	{
		const char* Hallo = "Hallo";
		void* p = processHeap.malloc(10);
		strcpy((char*)p, Hallo);
		p = processHeap.realloc(p, 100);
		assert(strcmp((char*)p, Hallo) == 0);
		p = processHeap.realloc(p, 90);
		assert(strcmp((char*)p, Hallo) == 0);
		p = processHeap.realloc(p, 3000);
		assert(strcmp((char*)p, Hallo) == 0);
		p = processHeap.realloc(p, 777777);
		assert(strcmp((char*)p, Hallo) == 0);
		p = processHeap.realloc(p, 20);
		assert(strcmp((char*)p, Hallo) == 0);
		processHeap.free(p);
	}
	
	cout << "Main thread: " << PThreadRunner::self() << endl;
	
	Foo foo;

	mem_fun(&Foo::gunc)(&foo);
	mem_fun_ref(&Foo::gunc)(foo);
	mem_fun_ref(&Foo::punk)(foo, "hallo");

	PThreadRunner::function(foo, &Foo::hunc);
	//PThreadRunner::function(bind1st(mem_fun_ref(&Foo::gunc), foo));


	cout << "lowest: " << OSSpecific::ThreadTraits::get_lowest_priority() << endl;
	cout << "below normal: " << OSSpecific::ThreadTraits::get_below_normal_priority() << endl;
	cout << "normal: " << OSSpecific::ThreadTraits::get_normal_priority() << endl;
	cout << "above normal: " << OSSpecific::ThreadTraits::get_above_normal_priority() << endl;
	cout << "highest: " << OSSpecific::ThreadTraits::get_highest_priority() << endl;
	
	PTSemaphore guard;

	const size_t count = 10;
	
	for(size_t i = 0; i < count; ++i)
	{
		PThreadRunner::start(
			PThreadRunner::function(foo, &Foo::hunc), 
			PThreadRunner::function(guard, &PTSemaphore::up));
	}

	for(size_t i = 0; i < count; ++i)
	{
		guard.down();
	}


	LockFree::Private::pt_get_optimal_size_of_memory_chunk_batch(777*sizeof(double));


	Dick<unsigned> d;

	char* dsAddress = reinterpret_cast<char*>(&d);
	char* dsNextAddress = reinterpret_cast<char*>(&d.next_);
	pt_uint_t diff = dsNextAddress - dsAddress;
	pt_uint_t offset = offsetof(Dick<unsigned>, next_);
	char* dsNextAddress2 = dsAddress + offset;
	LockFree::Private::PTPointerLLSC* p = reinterpret_cast<LockFree::Private::PTPointerLLSC*>(reinterpret_cast<char*>(&d) + offsetof(Dick<unsigned>, next_));
	p = reinterpret_cast<LockFree::Private::PTPointerLLSC*>(dsNextAddress2);
	p->assign(42*8, 0);

	//testMemoryChunk();

	cout << "OK\n";
	return 0;
}


