#include <iostream>
#include <cstdio>
#include <portablethreads/time.h>
#include <platypus/answer_set_printer_base.h>
#include <platypus/types/partial_assignment.h>
#include <distribution/fork/printer_thread.h>

#ifdef _MSC_VER
#	pragma warning(disable:4267) // size_t printing
#endif

namespace Platypus
{
	PrinterThread::~PrinterThread()
	{
		//std::printf("PrinterThread d'tor\n");
	}
	PrinterThread::PrinterThread(	PrinterThreadCallback& callback, 
									const ProgramInterface& program, 
									AnswerSetPrinterBase& printer, 
									size_t requested_answersets,
									unsigned delay)
									:	callback_(&callback)
									,	program_(&program)
									,	printer_(&printer)
									,	requestedAnswerSets_(requested_answersets)
									,	printedAnswerSets_(0)
									,	delay_(delay)
									,	shutdown_(false)
									,	terminate_(false)
	{}
	void PrinterThread::terminate()
	{
		terminate_ = true;
	}
	void PrinterThread::shutdown()
	{
		shutdown_ = true;
	}
	bool PrinterThread::enoughPrinted() const
	{
		if(requestedAnswerSets_)
			return printedAnswerSets_ == requestedAnswerSets_;
		return false;
	}
	void PrinterThread::print(PartialAssignment& pa)
	{
		printer_->print(++printedAnswerSets_, pa);
	}
	void PrinterThread::threadMain()
	{
		//std::printf("PrinterThread started\n");

		PartialAssignment pa(*program_);
		while(!terminate_ && !enoughPrinted())
		{
			if(callback_->retrieveAnswerSetForPrinting(pa))
			{
				print(pa);
			}
			else
			{	
				if(shutdown_)
					break;
				PortableThreads::pt_milli_sleep(delay_);
			}	
		}

		//std::printf("PrinterThread ended\n");
	}
}
