#include <distribution/mpi/mpi_control_exit_handler.h>

namespace Platypus
{
  
  MPIControlExitHandler::MPIControlExitHandler()
    :   workers_(0)
    ,   requests_(0)
  {}
  
  MPIControlExitHandler::~MPIControlExitHandler()
  {}
  
  void MPIControlExitHandler::setup(unsigned workers)
  {
    workers_ = workers;
  }
  
  void MPIControlExitHandler::incRequests(unsigned inc)
  {
    requests_ += inc;
  }
  
  void MPIControlExitHandler::decRequests(unsigned inc)
  {
    requests_ -= inc;
  }
  
  bool MPIControlExitHandler::exit() const
  {
    return workers_ == requests_;
  }

}

