#ifndef MPI_CONTROL_STATE_HANDLER_H
#define MPI_CONTROL_STATE_HANDLER_H

#include <vector>
#include <iostream>
#include <distribution/mpi/mpi_platypus_types.h>

using std::vector;

namespace Platypus
{

  /**
   * Stores state information for individual workers.
   */
  class MPIControlStateHandler
    {
    public:
      MPIControlStateHandler();
      ~MPIControlStateHandler();

      /**
       * Setup number if indices.
       */
      void setup(unsigned entries);
      /**
       * Set the state information for the worker with the given index.
       */
      void setState(unsigned index, unsigned state);
      /**
       * Get the state information for the worker with the given index.
       */
      unsigned getState(unsigned index) const;
      /**
       * Return the first index with the specified state.
       */
      //unsigned findState(unsigned state) const; //find the first worker with the specified state
      /** 
       * Return a pointer to the data structure containing the states.
       */
      vector<unsigned> * getStates(){ return &states_; }

    private:

      vector<unsigned> states_;
      unsigned entries_;
      
    };

}


#endif
