#ifndef MPI_STATISTICS_H
#define MPI_STATISTICS_H

#include <vector>
#include <iostream>
#include <distribution/mpi/mpi_platypus_types.h>

using std::vector;

namespace Platypus
{

  class MPIStatistics
    {
    public:
      MPIStatistics();
      ~MPIStatistics();
      
      void setup(unsigned indices);
      
      //following methods take care of tracking messages for
      //the entire run and individual precesses
      void incMessagesSent(unsigned index, unsigned long inc = 1);
      void incMessagesReceived(unsigned index, unsigned long inc = 1);
      void incExpanderInits(unsigned index, unsigned long inc=1);
      void incConflicts(unsigned index, unsigned long inc=1);
      void incModels(unsigned index, unsigned long inc=1);
      void incBacktracks(unsigned index, unsigned long inc=1);
      void incThreadDelegations(unsigned index, unsigned long inc=1);
      void incWorkRequestsToMaster(unsigned index, unsigned long inc = 1);
      void incWorkRequestsFromMaster(unsigned index, unsigned long inc = 1);
      void incWorkDenials(unsigned index, unsigned long inc = 1);
      void incWorkDelegationsToMaster(unsigned index, unsigned long inc = 1);
      void incWorkDelegationsFromMaster(unsigned index, unsigned long inc = 1);
      void incDroppedRequests(unsigned index, unsigned long inc = 1);
      void incTotalIdleTime(unsigned index, unsigned long inc);
      void incTotalWorkingTime(unsigned index, unsigned long inc);
      void incTotalTime(unsigned index, unsigned long inc);
      void incTotalCommTime(unsigned index, unsigned long inc);
      void incTotalDelegTime(unsigned index, unsigned long inc);

      unsigned long messagesSent() const;
      unsigned long messagesReceived() const;
      unsigned long expanderInits() const;
      unsigned long conflicts() const;
      unsigned long models() const;
      unsigned long backtracks() const;
      unsigned long threadDelegations() const;
      unsigned long workRequestsToMaster() const;
      unsigned long workRequestsFromMaster() const;
      unsigned long workDenials() const;
      unsigned long workDelegationsToMaster() const;
      unsigned long workDelegationsFromMaster() const;
      unsigned long droppedRequests() const;

      unsigned long indexMessagesSent(unsigned index) const;
      unsigned long indexMessagesReceived(unsigned index) const;
      unsigned long indexExpanderInits(unsigned index) const;
      unsigned long indexConflicts(unsigned index) const;
      unsigned long indexModels(unsigned index) const;
      unsigned long indexBacktracks(unsigned index) const;
      unsigned long indexThreadDelegations(unsigned index) const;
      unsigned long indexWorkRequestsToMaster(unsigned index) const;
      unsigned long indexWorkRequestsFromMaster(unsigned index) const;
      unsigned long indexWorkDenials(unsigned index) const;
      unsigned long indexWorkDelegationsToMaster(unsigned index) const;
      unsigned long indexWorkDelegationsFromMaster(unsigned index) const;
      unsigned long indexDroppedRequests(unsigned index) const;
      unsigned long indexTotalIdleTime(unsigned index) const;
      unsigned long indexTotalWorkingTime(unsigned index) const;
      unsigned long indexTotalTime(unsigned index) const;
      unsigned long indexTotalCommTime(unsigned index) const;
      unsigned long indexTotalDelegTime(unsigned index) const;

      void incTotalExpansionTime(unsigned index, unsigned long inc);
      void incTotalExpansionTimeWithRequestsPending(unsigned index, unsigned long inc);
      void incTotalExpandsWithRequestsPending(unsigned index, unsigned long inc);
      unsigned long indexTotalExpansionTime(unsigned index) const;
      unsigned long indexTotalExpansionTimeWithRequestsPending(unsigned index) const;
      unsigned long indexTotalExpandsWithRequestsPending(unsigned index) const;
      double totalExpansionTime() const;
      double totalExpansionTimeWithRequestsPending() const;
      unsigned long totalExpandsWithRequestsPending() const { return totalExpandsWithRequestsPending_; }
 
      void incTotalExpanderReinitializationTime(unsigned index, unsigned long inc);
      unsigned long indexTotalExpanderReinitializationTime(unsigned index) const;
      double totalExpanderReinitializationTime() const;

      void incTotalExpanderReinitializationsWithRequestsPending(unsigned index, unsigned long inc);
      unsigned long indexTotalExpanderReinitializationsWithRequestsPending(unsigned index) const;
      double totalExpanderReinitializationsWithRequestsPending() const { return totalExpanderReinitializationsWithRequestsPending_; }

      inline void incAnswers(unsigned long inc = 1){ answers_ += inc; }
      inline unsigned long answers(){ return answers_; }

      void checkMaxQueueSize(unsigned queueSize);
      unsigned maxQueueSize() const;

      void checkMaxFiledWorkers(unsigned filedWorkers);
      unsigned maxFiledWorkers();

      inline void incTotalDCMessageCount(unsigned long messageLength){ totalDCMessageCount_ += messageLength; } 
      inline void incTotalDCMessages(unsigned long inc = 1){ totalDCMessages_ += inc; }
      void setLargestDCMessage(unsigned long messageLength);
      unsigned long getLargestDCMessage(){ return largestDCMessage_; }
      unsigned long getTotalDCMessages(){ return totalDCMessages_; }
      unsigned long getAverageDCMessageLength();

      double getTotalIdleTime() const;
      double getAverageIdleTime() const;
      double getTotalWorkingTime() const;
      double getAverageWorkingTime() const;
      double getTotalTime() const;
      double getAverageTime() const;
      double getTotalCommTime() const;
      double getAverageCommTime() const;
      double getTotalDelegTime() const;
      double getAverageDelegTime() const;

    private:

      typedef std::vector<unsigned long> IndexedStatistics;

      unsigned indices_;
      
      //global message count
      unsigned long totalMessagesSent_;
      unsigned long totalMessagesReceived_;
      unsigned long totalExpanderInits_;
      unsigned long totalConflicts_;
      unsigned long totalModels_;
      unsigned long totalBacktracks_;
      unsigned long totalThreadDelegations_;
      unsigned long totalWorkRequestsToMaster_;
      unsigned long totalWorkRequestsFromMaster_;
      unsigned long totalWorkDenials_;
      unsigned long totalDelegationsToMaster_;
      unsigned long totalDelegationsFromMaster_;
      unsigned long totalDroppedRequests_;
      unsigned long totalExpandsWithRequestsPending_;
      unsigned long totalExpanderReinitializationsWithRequestsPending_;

      IndexedStatistics messagesSent_;
      IndexedStatistics messagesReceived_;
      IndexedStatistics expanderInits_;
      IndexedStatistics conflicts_;
      IndexedStatistics models_;
      IndexedStatistics backtracks_;
      IndexedStatistics threadDelegations_;
      IndexedStatistics workRequestsToMaster_;
      IndexedStatistics workRequestsFromMaster_;
      IndexedStatistics workDenials_;
      IndexedStatistics delegationsToMaster_;
      IndexedStatistics delegationsFromMaster_;
      IndexedStatistics droppedRequests_;
      IndexedStatistics totalIdleTime_;
      IndexedStatistics totalWorkingTime_;
      IndexedStatistics totalTime_;
      IndexedStatistics totalCommTime_;
      IndexedStatistics totalDelegTime_;
      IndexedStatistics expansionTime_;
      IndexedStatistics expansionTimeWithRequestsPending_;
      IndexedStatistics expandsWithRequestsPending_;
      IndexedStatistics expanderReinitializationTime_;
      IndexedStatistics expanderReinitializationsWithRequestsPending_;
     
      unsigned long answers_;
      unsigned maxQueueSize_;
      unsigned maxFiledWorkers_;

      //added to get a feel for the size of the delegatable choices being passed around
      unsigned long totalDCMessageCount_;
      unsigned long totalDCMessages_;
      unsigned long largestDCMessage_;

    };

}


#endif
