#include <distribution/mpi/platypus_time.h>

namespace Platypus
{
  
  Time::Time()
    :	start_(0)
    ,	end_(0)
    ,   frequency_(1000000)
  {
    assert(frequency_ && "This platform does not support high performance clocks!");
  }
  
  uint64 Time::stamp() const
  {
    timeval tv;
    gettimeofday(&tv, 0);
    
    uint64 t = tv.tv_usec;
    t += tv.tv_sec*1000000;
    return t;
  }
  
  uint64 Time::calculateFrequency()
  {
    return 1000000;
  }

  //const uint64 Time::frequency_ = Time::calculateFrequency();

}
