#ifndef PLATYPUS_TIME_H
#define PLATYPUS_TIME_H

#include <cerrno>
#include <cassert>
#include <unistd.h>
#include <signal.h>
#include <ctime>
#include <sys/time.h>
#include <sys/wait.h>
#include <distribution/mpi/ticks.h>

namespace Platypus
{

  /**
   * Provides fast and efficient high resolution timing for debugging purposes.
   */
  class Time
  {
  public:
    Time();
    //:	start_(0)
    //,	end_(0)
    //{
    //assert(frequency_ && "This platform does not support high performance clocks!");
    //}
    inline uint64 frequency() const
    {
      return frequency_;
    }
    inline void start()
    {
      start_ = end_ = stamp();
    }
    inline void stop()
    {
      end_ = stamp();
    }
    inline uint64 difference() const
    {
      return end_ - start_;
    }
    uint64 stamp() const;
  private:
    uint64 calculateFrequency();
  private:
    uint64 start_, end_;
    uint64 frequency_;
  };

  /*
    uint64 Time::stamp() const
    {
    timeval tv;
    gettimeofday(&tv, 0);
    
    uint64 t = tv.tv_usec;
    t += tv.tv_sec*1000000;
    return t;
    }
    
    uint64 Time::calculateFrequency()
    {
    return 1000000;
    }
  */
  //const uint64 Time::frequency_ = Time::calculateFrequency();

}

#endif
