#ifndef SERIALIZER_BASE_H
#define SERIALIZER_BASE_H

#include <platypus/types_fwd.h>

namespace Platypus
{

  class SerializerBase
  {
  public:
    
    //SerializerBase() {}
    virtual ~SerializerBase() {}
    
    virtual size_t bytesRequired() const = 0;
    template<class T> void deserialize(DelegatableChoice& dc, const T& buffer) const;
    template<class T> void serialize(T& buffer, const DelegatableChoice& dc) const;
    
    template<class T> void deserialize(PartialAssignment& pa, const T& buffer) const;
    template<class T> void serialize(T& buffer, const PartialAssignment& pa) const;
    
  };
}

#endif
