#include <nomore/graph_cloner.h>
#include <head_node.h>
#include <body_node.h>
#include <cassert>

#if defined (_MSC_VER) && _MSC_VER <= 1300
#define for if (0) ; else for
#endif


namespace NS_NOMORE {

GraphCloner::GraphCloner() {

}

GraphCloner::~GraphCloner() {

}


Graph* GraphCloner::clone(const Graph& toClone) {
	theClone_.reset(new Graph);
	toClone_ = &toClone;

	// first clone all nodes...
	size_t maxNode = toClone.countNodes();
	for (size_t i = 0; i != maxNode; ++i) {
		cloneNode(toClone.getNode((long)i));
	}

	// ...then establish relations...
	for (size_t i = 0; i != maxNode; ++i) {
		addSuccessors((long)i);
	}
	theClone_->setTightness(toClone_->tightness());
	return theClone_.release();  
}



void GraphCloner::addSuccessors(long i) {
	Node* orig = toClone_->getNode(i);
	if (orig->getType() == NodeType::head_node) {
		addSuccessors(static_cast<HeadNode*>(orig), static_cast<HeadNode*>(theClone_->getNode(i)));
  }
  else {
		addSuccessors(static_cast<BodyNode*>(orig), static_cast<BodyNode*>(theClone_->getNode(i)));
  }
}

void GraphCloner::addSuccessors(BodyNode* original, BodyNode* clone) {
  for (BodyNode::HeadNodeIterator it = original->successorsBegin(); it != original->successorsEnd(); ++it) {
    clone->insertSuccessor(*static_cast<HeadNode*>(theClone_->getNode((*it)->getId())));
  }
}

void GraphCloner::addSuccessors(HeadNode* original, HeadNode* clone) {
  for (HeadNode::BodyNodeIterator it = original->zeroSuccessorsBegin(); it != original->zeroSuccessorsEnd(); ++it) {
    clone->insertZeroSuccessor(*static_cast<BodyNode*>(theClone_->getNode((*it)->getId())));
  }
  for (HeadNode::BodyNodeIterator it = original->oneSuccessorsBegin(); it != original->oneSuccessorsEnd(); ++it) {
    clone->insertOneSuccessor(*static_cast<BodyNode*>(theClone_->getNode((*it)->getId())));
  }
}


void GraphCloner::cloneNode(Node* original) {
	Node* clone;
	if (original->getType() == NodeType::head_node) {
		HeadNode* h = static_cast<HeadNode*>(original);
		clone = theClone_->insertHeadNode(h->getAtomId());
    static_cast<HeadNode*>(clone)->setAtomName(h->getAtomName());
	}
	else {
     clone = theClone_->insertBodyNode();
  }
  clone->setComponentNumber(original->getComponentNumber());
}

}
