#ifndef UTIL_QUEUE_H_INCLUDED
#define UTIL_QUEUE_H_INCLUDED
#if defined (_MSC_VER) && _MSC_VER <= 1200
#pragma warning (disable : 4786)
#endif
#include <deque>
namespace util {

// A queue-Adapater similar to std::queue.
// In contrast to std::queue it provides a swap-function as well as read-access
// to the adapted container.
template <class T, class C = std::deque<T> >
class queue {
public:
  typedef C container_type;
  typedef typename container_type::size_type size_type;
  typedef typename container_type::value_type value_type;
  
  queue() {}

  bool empty() const            { return container_.empty(); }
  size_type size() const        { return container_.size();  }
  value_type& front()           { return container_.front(); }
  const value_type& front()const{ return container_.front(); }
  value_type& back()            { return container_.back();  }
  const value_type& back() const{ return container_.back();  }
  void push(const value_type& x){ container_.push_back(x);  }
  void pop()                    { container_.pop_front(); }
  
  bool operator==(const queue& other) const {
    return container_ == other.container_;
  }

  bool operator!=(const queue& other) const {
    return container_ != other.container_;
  }
  
  bool operator<(const queue& other) const {
    return container_ < other.container_;
  }
  
  void swap(queue& other) {
    container_.swap(other.container_);
  }
  
  void clear() {
    container_.clear();
  }
  const container_type& container() const {
    return container_;
  }
  
private:
  container_type container_;
};

  
}

#endif
