#ifndef NOMORE_PROGRAM_H_INCLUDED
#define NOMORE_PROGRAM_H_INCLUDED

#include <memory>
#include <platypus/types/program.h>
#include <portablethreads/lock_free.h>

namespace Platypus { namespace Nomore { 

class NomoreSystem;

/*!
 * A Nomore Program reads lparse from an istream and creates
 * a corresponding body-head graph.
 * 
 */
class Program : public Platypus::Program
{
public:
	typedef Platypus::Program BaseType;

	Program();
	~Program();

	// base interface
	using BaseType::setup;

	void setup(std::istream& is);
	std::string idToName(AtomId id) const;
	const CollectionType& atoms() const;

	size_t numberOfAtoms() const;
	size_t numberOfRules() const;

	bool hasDisplayName(AtomId id) const;

	// new interface
	NomoreSystem* createNomoreSystem() const;
private:
	// nomore programs are neither copyable nor assignable
	Program(const Program&);
	Program& operator=(const Program&);

	std::auto_ptr<NomoreSystem> nomore_;
	CollectionType	atoms_;
	mutable PortableThreads::LockFree::PTAtomicNumber	expanders_;	
};

} }

#endif
