/*	$Id: options.h 3090 2006-01-10 17:07:17Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <program_options/program_options_fwd.h>

namespace Platypus
{
	class PlatypusOptions
	{
	public:
		PlatypusOptions();
		void options(const ProgramOptions::OptionValues& values);
		const std::string& filename() const { return filename_; }
		const std::string& localChoicePolicy() const { return localChoicePolicy_; }
		void localChoicePolicy(const std::string& name) { localChoicePolicy_ = name; }
		const std::string& delegatableChoicePolicy() const { return dcChoicePolicy_; }
		const std::string& threadDelegationPolicy() const { return threadDelegationPolicy_; }
		size_t requestedAnswerSets() const { return requestedAnswerSets_; }
		bool debugPrinting() const { return debugPrinting_; }
		void debugPrinting(bool b) { debugPrinting_ = b; }
		bool wantHelpOnOptions() const { return wantHelpOnOptions_; }
		bool silent() const { return silent_; }
		const std::string& expander() const { return expander_; }
		const std::string& core() const { return core_; }
		void core(const std::string& c) { core_ = c; }
		unsigned threads() const { return threads_; }
		const std::string& mode() const { return mode_; }
		bool manualChoices() const { return manualChoices_; }
		bool probing() const { return probing_; }
		unsigned probingInitialCutoff() const { return probingInitialCutoff_; }
		unsigned probingJumps() const { return probingJumps_; }
		unsigned probingBestN() const { return probingBestN_; }
		const std::string& probingPolicy() const { return probingPolicy_; }
		bool wantVersion() const { return wantVersion_; }
	private:
		std::string localChoicePolicy_, dcChoicePolicy_, threadDelegationPolicy_, filename_, expander_, core_, mode_, probingPolicy_;
		size_t requestedAnswerSets_;
		unsigned threads_, probingInitialCutoff_, probingJumps_, probingBestN_;
		bool debugPrinting_, wantHelpOnOptions_, silent_, manualChoices_, probing_, wantVersion_;
	};
}

#endif
