/*	$Id: foreman.h 8281 2007-11-10 13:45:35Z martin $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef FOREMAN_H
#define FOREMAN_H

#include <smartpointer.h>
#include <portablethreads/semaphore.h>
#include <portablethreads/lock_free.h>
#include <platypus/types_fwd.h>
#include <platypus/exceptions.h>
#include <platypus/types/choice.h>
#include <platypus/types/partial_assignment.h>
#include <platypus/cores/core_callback.h>

class NopStream;
namespace Platypus
{
	class ForemanAssistant
	{
	public:
		ForemanAssistant();
		void program(ProgramInterface& prog);
		void distribution(CoreDistributionCallback& callback);
		void factory(const PlatypusTypesFactory& factory);
		void output(NopStream& str);
		void options(const PlatypusOptions& values);
		Expander* expander(const DelegatableChoice& dc = DelegatableChoice()); 
		DelegatableChoicePolicy::PolicyBase* delegatableChoicePolicy();
		DelegatableChoicePolicy::PolicyBase* threadDelegationPolicy();
		ProbingPolicy::PolicyBase* probingPolicy();
		ProbingManager* probingManager();
		NopStream* output();
		size_t atoms() const;
		int processId() const;
		void processId(int id);
		bool silent() const;
	private:
		int processId_;
		ProgramInterface* program_;
		const PlatypusTypesFactory* factory_;
		const PlatypusOptions* options_;
		NopStream* os_;
	};

	class Worker;
	class PlatypusException;
	class Foreman	
	{
	public:
		~Foreman();
		Foreman();
		void threads(unsigned);
		void silent(bool yes);
		void program(const ProgramInterface& prog);
		void distribution(CoreDistributionCallback& callback);
		void assistant(ForemanAssistant& assistant);
		void output(NopStream& str);
		void setup();
		void run();	
	public:
		bool shutdown();
		bool needDelegatableChoice();		
		void delegate(const DelegatableChoice& dc);
		bool needBranch();
		void branch(const DelegatableChoice& dc);
		void answerSet(const PartialAssignment& pa);
		void markConflict();
		void markAnswerSet();
		void markBacktrack();
		void markExpanderInitialization();
		bool wait();
		DelegatableChoice retrieve();
		void exception(const PlatypusException& e);
		void startExpansion();
		void finishExpansion();
		void startExpanderReinitialization();
		void finishExpanderReinitialization();
	private:
		void iterate();
		void updateStatistics();
		void handleDelegation();
		void handleAnswerSets(int answerSetsToPrint);
		void handleNoWork();
		void handleExceptions();
		void createThreads();
		void startThreads();
		void joinThreads();
		void addToThreadQueue(const DelegatableChoice& dc, bool forman);
	private:
		typedef PortableThreads::LockFree::PTQueue<DelegatableChoice> Queue;
		typedef PortableThreads::LockFree::PTStack<PartialAssignment> AnswerSetStack;
		typedef PortableThreads::LockFree::PTStack<PlatypusException> ExceptionStack;
		typedef PortableThreads::LockFree::PTAtomicNumber::int_type int_type;
		typedef std::vector< toolbox::StackPtr<Worker> > Workers;
	private:
		Workers workers_;
		PortableThreads::LockFree::PTAtomicNumber deltaAnswerSets_, deltaConflicts_, deltaBacktracks_, deltaInits_, deltaDelegations_;
		PortableThreads::LockFree::PTAtomicNumber threadsThatNeedSomethingToDo_;
		PortableThreads::PTSemaphore blockOnLocalQueue_;
		Queue localQueue_, delegateQueue_;
		AnswerSetStack answerSets_;
		ExceptionStack exceptions_;
		PlatypusException speedupExceptionHandling_;
		toolbox::SmartPtr<PartialAssignment> speedupAnserSetHandling_;
	
		ForemanAssistant* assistant_;
		CoreDistributionCallback* traits_;
		const ProgramInterface* program_;
		NopStream* os_;
		int_type threads_;
		const int answerSetsToPassOn_;
		bool filedForDCWithTraits_, silent_;
		volatile bool shutdown_;
		volatile bool flagNeedForDC_;
	};
}

#endif
