/*	$Id: smodels_program.h 2137 2005-07-03 10:22:28Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef SMODELS_PROGRAM_H
#define SMODELS_PROGRAM_H

#include <iosfwd>
#include <string>
#include <memory>
#include <vector>
#include <platypus/types/program.h>


namespace Platypus
{
	const char* const SMODELS_EMPTY_PROGRAM = "0\n0\nB+\n0\nB-\n0\n1\n";
	// Unfortunately we cannot build a program-wide
	// Platypus::AtomId to Smodels ::Atom* or Smodels atom[] index
	// translation -> first part is because each expander has
	// its own set of atoms and hence atom addresses -> pointers!
	// second part is because the content of the atom[] changes
	// permanently as smodels derives new atoms.
	class SmodelsHolder;
	class SmodelsHolderFactory;
	class SmodelsEnhancedProgram : public Program
	{
	public:
		SmodelsEnhancedProgram();
		~SmodelsEnhancedProgram();
				
		static ProgramInterface* create();
		using Program::setup;
		void setup(std::istream& input);

		// returns the associated name for an atom
		std::string idToName(AtomId id) const;
		
		// returns the collection of atoms of the logic program
		const CollectionType& atoms() const;
		
		// Returns the definite number of atoms in the logic program.
		// For instance the logic program
		// d :- {c} 1.
		// c.
		//
		// after being preprocessed by lparse contains FOUR atoms.
		size_t numberOfAtoms() const;
		size_t numberOfRules() const;
		
		// returns true if the atom had a name in the original (textual program), false otherwise.
		bool hasDisplayName(AtomId id) const;	
		
		// returns an lparse representation of the preprocessed program.
		SmodelsHolder* holder() const;
	private:
		void setName(size_t, const char*);
		void checkId(AtomId id) const;	
	private:
		std::auto_ptr<SmodelsHolderFactory> factory_;
		std::vector<const char*> ids_;
		CollectionType atoms_;
		size_t maxAtomId_;
	};
}

#endif
