/*	$Id: smodels_wrapper.h 2140 2005-07-03 11:28:23Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_SMODELS_WRAPPER_H
#define PLATYPUS_SMODELS_WRAPPER_H

#include <stdexcept>
#include <string>
#include <memory>
#include <iosfwd>
#include <iterator>
#include <smodels/list.h>

#ifdef LACKS_ITERATOR
namespace std
{
	template
	<
		class Category,
		class Type,
		class Distance = ptrdiff_t,
		class Pointer = Type*,
		class Reference = Type&
	>
   	struct iterator {
   		typedef Category iterator_category;
   		typedef Type value_type;
   		typedef Distance difference_type;
   		typedef Pointer pointer;
   		typedef Reference reference;
   	};
}
#endif


class Api;
class Smodels;
class Atom;
class Rule;


namespace Platypus
{
	struct SmodelsWrapperError : public std::logic_error
	{
		SmodelsWrapperError(const std::string& reason)
			:	std::logic_error(reason)
		{}
	};

	struct SmodelsParseError : public SmodelsWrapperError
	{
		SmodelsParseError(const std::string& reason)
			:	SmodelsWrapperError(reason)
		{}
	};

	template<class T>
	class Iterator : public std::iterator<std::forward_iterator_tag, T> 
	{
		typedef std::iterator<std::forward_iterator_tag, T> Base;
		::Node* current_;
	public:
		typedef typename Base::pointer pointer;
		typedef typename Base::reference reference;
		operator const void*() const { return current_; }
		Iterator(::Node* node = 0)
			:	current_(node)
		{}
		pointer operator->() const
		{
			return current_->atom;
		}
		reference operator*() const
		{
			return *(current_->atom);
		}
		Iterator& operator++()
		{
			if(current_)
				current_ = current_->next;
			return *this;
		}
		Iterator operator++(int)
		{
			Iterator temp(*this);
			++(*this);
			return temp;
		}
	};
	typedef Iterator< ::Atom > SmodelsAtomsIterator;
	typedef Iterator<const ::Atom> SmodelsAtomsConstIterator;


	class SmodelsHolder
	{
	public:
		~SmodelsHolder();
		typedef SmodelsAtomsConstIterator const_iterator;
		inline bool good() const { return smodels_.get() != 0; }
		inline operator const bool() const { return good(); }
		SmodelsHolder(const Api* api);
		Smodels* finalize();
		const_iterator begin() const;
		const_iterator end() const;
		bool addComputeStatement(const_iterator it, bool setTrue);
		const ::Smodels* smodels() const;
		::Api* api();
	private:
		SmodelsHolder();
		SmodelsHolder(const SmodelsHolder&);
		SmodelsHolder& operator=(const SmodelsHolder&);
	private:
		std::auto_ptr< ::Smodels > smodels_;
		std::auto_ptr< ::Api > api_;
	};

	class SmodelsHolderFactory
	{
	public:
		~SmodelsHolderFactory();
		SmodelsHolderFactory(std::istream& is);		
		SmodelsHolderFactory(const Api* api);
		SmodelsHolder* create() const;
		const ::Smodels* smodels() const;
	private:
		SmodelsHolderFactory();
		SmodelsHolderFactory(const SmodelsHolderFactory&);
		SmodelsHolderFactory& operator=(const SmodelsHolderFactory&);
	private:
		const std::auto_ptr< ::Smodels > smodels_;
		const std::auto_ptr< ::Api > api_;
	};

};

#endif
