/*	$Id: chooser.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef CHOICE_POLICY_H
#define CHOICE_POLICY_H

#include <cassert>
#include <portablethreads/random.h>
#include <platypus/types/choice.h>

namespace Platypus
{
	namespace ChoicePolicy
	{
		class PolicyBase
		{
		public:
			virtual ~PolicyBase()
			{}
			virtual PolicyBase* clone() const = 0;
			virtual Choice getChoice(const PossibleChoices&) = 0;
		};

		class RandomBase : public PolicyBase
		{
		public:
			RandomBase();
		protected:
			Choice getChoice(const PossibleChoices& possible, bool positive);
			unsigned long urand();
		private:
			PortableThreads::PTRandom rng_;
		};

		// choose random choice id, make it true
		class RandomTrue : public RandomBase
		{
		public:
			PolicyBase* clone() const;
			Choice getChoice(const PossibleChoices&);
			static PolicyBase* create();
		};
		// choose random choice id, make it false
		class RandomFalse : public RandomBase
		{
		public:
			PolicyBase* clone() const;
			Choice getChoice(const PossibleChoices&);
			static PolicyBase* create();
		};
		// choose random choice id, make it either true or false
		class RandomRandom : public RandomBase
		{
		public:
			PolicyBase* clone() const;
			Choice getChoice(const PossibleChoices&);
			static PolicyBase* create();
		};
	}
}	

#endif
