/*	$Id: choices_to_do.h 2069 2005-06-29 09:54:14Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef CHOICES_TO_DO_H
#define CHOICES_TO_DO_H

#include <platypus/types/choice.h>
#include <platypus/types/search_space.h>

namespace Platypus
{
	class ChoicesToDo
	{
	public:
		~ChoicesToDo();
		ChoicesToDo(SearchSpace& space);
		ChoicesToDo(SearchSpace& space, SearchSpace::cursor coreEnd);
		
		// adds a choice to the "choices todo" collection
		void add(const Choice& choice);
		
		// returns true whenever there are choices stored, false otherwise
		bool hasChoice() const;
		
		// returns the next (local choice to be change using the 
		// builtin policy (chronological backtracking)
		Choice nextChoice();	

		Branch core();
		void swap(ChoicesToDo& other);
		void release();
	private:
		void extendCore();
	private:
		SearchSpace* space_;
		SearchSpace::cursor localRoot_, coreEnd_, active_;
	};
}

#endif
