
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/config.h>

using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree::Private;


class AtomicFunctionsTest : public CppUnit::TestFixture
{
public:
	void testSetAndClearLock()
	{
		volatile uint8 lock = 0;
		volatile uint8 check = 0;
		
		pt_atomic_clear_lock(&lock);
		CPPUNIT_ASSERT_EQUAL(check, lock);

		CPPUNIT_ASSERT_EQUAL(true, pt_atomic_set_lock(&lock));
		CPPUNIT_ASSERT_EQUAL(false, pt_atomic_set_lock(&lock));

		CPPUNIT_ASSERT(check != lock);

		pt_atomic_clear_lock(&lock);
		CPPUNIT_ASSERT_EQUAL(check, lock);
		pt_atomic_clear_lock(&lock);
		CPPUNIT_ASSERT_EQUAL(check, lock);
	}
#ifdef PT_HAVE_CAS
	void testCas()
	{
		volatile pt_int_type i = 0;
		volatile pt_int_type check = 42;

		CPPUNIT_ASSERT_EQUAL(true, pt_atomic_cas(&i, 42, 0));
		CPPUNIT_ASSERT_EQUAL(check, i);
		CPPUNIT_ASSERT_EQUAL(false, pt_atomic_cas(&i, 42, 0));
		CPPUNIT_ASSERT_EQUAL(check, i);
		CPPUNIT_ASSERT_EQUAL(true, pt_atomic_cas(&i, -3, 42));
		check = -3;
		CPPUNIT_ASSERT_EQUAL(check, i);
	}
	void testArithmetic()
	{
		volatile pt_int_type i = 0;
		volatile pt_int_type check = 42;

		pt_atomic_add(&i, 42);
		CPPUNIT_ASSERT_EQUAL(check, i);

		pt_atomic_add(&i, -42);
		check = 0;
		CPPUNIT_ASSERT_EQUAL(check, i);

		pt_atomic_sub(&i, 23);
		check = -23;
		CPPUNIT_ASSERT_EQUAL(check, i);

		pt_atomic_sub(&i, -23);
		check = 0;
		CPPUNIT_ASSERT_EQUAL(check, i);

		pt_atomic_inc(&i);
		pt_atomic_inc(&i);
		pt_atomic_inc(&i);

		check = 3;
		CPPUNIT_ASSERT_EQUAL(check, i);

		pt_atomic_dec(&i);
		check = 2;
		CPPUNIT_ASSERT_EQUAL(check, i);
	}
#endif
#ifdef PT_HAVE_CAS2
	void testCas2()
	{
		typedef Private::PTSizeToType<2*sizeof(pt_int_type)>::int_type large_int_type;
		volatile large_int_type i = 0xffffffff;
		i <<= 16;
		volatile large_int_type check = i;
		i = 0;

		CPPUNIT_ASSERT_EQUAL(true, pt_atomic_cas(&i, check, 0));
		CPPUNIT_ASSERT_EQUAL(check, i);
		CPPUNIT_ASSERT_EQUAL(false, pt_atomic_cas(&i, check, 0));
		CPPUNIT_ASSERT_EQUAL(check, i);
		CPPUNIT_ASSERT_EQUAL(true, pt_atomic_cas(&i, ~check, check));
		check = ~check;
		CPPUNIT_ASSERT_EQUAL(check, i);
	}
#endif
	CPPUNIT_TEST_SUITE( AtomicFunctionsTest );
		CPPUNIT_TEST( testSetAndClearLock );
#ifdef PT_HAVE_CAS
		CPPUNIT_TEST( testCas );
		CPPUNIT_TEST( testArithmetic );
#endif
#ifdef PT_HAVE_CAS2
		CPPUNIT_TEST( testCas2 );
#endif
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( AtomicFunctionsTest );



