// $Id: test_choices_to_do.cpp 2058 2005-06-29 07:52:37Z jgressma $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <functional>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/program_metadata.h>
#include <platypus/types.h>


using namespace std;
using namespace Platypus;

class ChoicesToDoTest : public CppUnit::TestFixture
{	
public:
	void testEmpty()
	{
		SearchSpace space;
		ChoicesToDo choicesToDo(space);

		// there should be no choice in a "default"
		// constructed choicestodo
		CPPUNIT_ASSERT_EQUAL(choicesToDo.hasChoice(), false);

		try
		{
			choicesToDo.nextChoice();
			CPPUNIT_ASSERT(false);
		}
		catch(NoChoiceLeft&)
		{}
	}
	void testSetSomeLocalChoices()
	{
		
		SearchSpace space;
		ChoicesToDo choicesToDo(space);

		Choice c1(1, true);
		Choice c2(2, false);
		Choice c3(3, false);
		
		
		choicesToDo.add(c1);
		choicesToDo.add(c2);
		choicesToDo.add(c3);

		CPPUNIT_ASSERT_EQUAL(choicesToDo.hasChoice(), true);
		Choice ex1(choicesToDo.nextChoice());
		CPPUNIT_ASSERT_EQUAL(ex1.id(), c3.id());
		CPPUNIT_ASSERT_EQUAL(ex1.isPositive(), true);

		CPPUNIT_ASSERT_EQUAL(choicesToDo.hasChoice(), true);
		Choice ex2(choicesToDo.nextChoice());
		CPPUNIT_ASSERT_EQUAL(ex2.id(), c2.id());
		CPPUNIT_ASSERT_EQUAL(ex2.isPositive(), true);

		CPPUNIT_ASSERT_EQUAL(choicesToDo.hasChoice(), true);
		Choice ex3(choicesToDo.nextChoice());
		CPPUNIT_ASSERT_EQUAL(ex3.id(), c1.id());
		CPPUNIT_ASSERT_EQUAL(ex3.isPositive(), false);

		CPPUNIT_ASSERT_EQUAL(choicesToDo.hasChoice(), false);
	}
	
	void testInitFromDelegatabeChoice()
	{
		Branch dc;
		dc.push_back(Choice(1, true));
		dc.push_back(Choice(2, false));
		dc.push_back(Choice(3, false));

		SearchSpace space(dc);
		ChoicesToDo choicesToDo(space);

		// there should be no choices in a "remotely"
		// constructed choicestodo
		CPPUNIT_ASSERT_EQUAL(false, choicesToDo.hasChoice());
	}
	

	void testCoreFromEmpty()
	{
		SearchSpace space;
		ChoicesToDo choicesToDo(space);

		DelegatableChoice core = choicesToDo.core();

		CPPUNIT_ASSERT_EQUAL(size_t(0), core.size());

		// must be idempotent!
		core = choicesToDo.core();
		CPPUNIT_ASSERT_EQUAL(size_t(0), core.size());
	}

	void testCoreFromInitialized()
	{
		DelegatableChoice thecore;
		thecore.push_back(Choice(1, true));
		thecore.push_back(Choice(42, true));

		SearchSpace space(thecore);
		ChoicesToDo choicesToDo(space, space.root().descend_left().descend_left());
		CPPUNIT_ASSERT_EQUAL(false, choicesToDo.hasChoice());
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());
		// idempotent!
		CPPUNIT_ASSERT_EQUAL(false, choicesToDo.hasChoice());
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());
	
	}
	void testCoreBehaviorAddTwoGetTwo()
	{
		DelegatableChoice thecore;
		thecore.push_back(Choice(1, true));
		thecore.push_back(Choice(42, true));


		// adding two choices
		SearchSpace space(thecore);
		ChoicesToDo choicesToDo(space, space.root().descend_left().descend_left());
		choicesToDo.add(Choice(13, false));
		choicesToDo.add(Choice(4, true));
		CPPUNIT_ASSERT_EQUAL(true, choicesToDo.hasChoice());

		// core still is only two choices b/c neither has been toggled or delegated
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());

		// taking the last choice
		Choice c = choicesToDo.nextChoice();
		CPPUNIT_ASSERT_EQUAL((ChoiceId)4, c.id());
		CPPUNIT_ASSERT_EQUAL(false, c.isPositive());

		// core must still only have two choices
		// last one was toggled, but there is another
		// one between it and the initial core
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());

		// one must remain
		CPPUNIT_ASSERT_EQUAL(true, choicesToDo.hasChoice());
		c = choicesToDo.nextChoice();
		CPPUNIT_ASSERT_EQUAL((ChoiceId)13, c.id());
		CPPUNIT_ASSERT_EQUAL(true, c.isPositive());

		// no choices left
		CPPUNIT_ASSERT_EQUAL(false, choicesToDo.hasChoice());

		// if we'd get the core now, there must
		// be three choices b/c the last choice 13
		// has been toggled
		thecore.push_back(Choice(13, true));
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());

	}
	void testCoreBehaviorAddOneGetOneAddOne()
	{
		DelegatableChoice thecore;
		thecore.push_back(Choice(1, true));
		thecore.push_back(Choice(42, true));

		// adding two choices
		SearchSpace space(thecore);
		ChoicesToDo choicesToDo(space, space.root().descend_left().descend_left());
		choicesToDo.add(Choice(13, false));
		CPPUNIT_ASSERT_EQUAL(true, choicesToDo.hasChoice());

		// core still is only two choices b/c neither has been toggled or delegated
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());

		// taking the last choice
		Choice c = choicesToDo.nextChoice();
		CPPUNIT_ASSERT_EQUAL((ChoiceId)13, c.id());
		CPPUNIT_ASSERT_EQUAL(true, c.isPositive());
		CPPUNIT_ASSERT_EQUAL(false, choicesToDo.hasChoice());

		// core must still only have two choices
		// last one was toggled, but there is another
		// one between it and the initial core
		thecore.push_back(Choice(13, true));
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());

		// add another choice
		choicesToDo.add(Choice(4, true));
		CPPUNIT_ASSERT_EQUAL(true, choicesToDo.hasChoice());

		// now the core must be three choices b/c choice 13
		// has already been toggled
		CPPUNIT_ASSERT_EQUAL(thecore, choicesToDo.core());

	}
	CPPUNIT_TEST_SUITE( ChoicesToDoTest );
		CPPUNIT_TEST( testEmpty );
		CPPUNIT_TEST( testSetSomeLocalChoices );
		CPPUNIT_TEST( testInitFromDelegatabeChoice );
		CPPUNIT_TEST( testCoreFromEmpty );
		CPPUNIT_TEST( testCoreFromInitialized );
		CPPUNIT_TEST( testCoreBehaviorAddTwoGetTwo );
		CPPUNIT_TEST( testCoreBehaviorAddOneGetOneAddOne );
		
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ChoicesToDoTest );


