/* 
 * eins - A tool for measuring network-bandwidths and -latencies.
 * Copyright (C) 2006  Hynek Schlawack <hs+eins@ox.cx>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef UTIL_H
#define UTIL_H

#include <sys/types.h>

#ifndef __likely
#define __likely(foo) __builtin_expect((foo),1)
#define __unlikely(foo) __builtin_expect((foo),0)
#endif

void *safe_alloc(size_t);
char *safe_strdup(const char *);
void randomize_buffer(char *, long long);
int split(char **stringp, const char *delim, char ***list);

#endif /* UTIL_H */
